/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyClient;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyAuthorisationHelper;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyGroup;
import org.nuiton.wikitty.entities.WikittyGroupImpl;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.entities.WikittyMetaExtensionUtil;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;
import org.nuiton.wikitty.search.Search;

public class WikittySecurityHelper {
    private static Log log = LogFactory.getLog(WikittySecurityHelper.class);
    public static final String WIKITTY_APPADMIN_GROUP_NAME = "WikittyAppAdmin";

    @Deprecated
    public static String getUserWikittyId(WikittyProxy proxy, String login) {
        String userWikittyId = null;
        Wikitty user = proxy.findByCriteria(Search.query().eq("WikittyUser.login", login).criteria());
        if (user != null) {
            userWikittyId = user.getWikittyId();
        }
        return userWikittyId;
    }

    public static String getUserWikittyId(WikittyClient client, String login) {
        WikittyQuery query = ((WikittyQueryMaker)new WikittyQueryMaker().eq("WikittyUser.login", (Object)login)).end();
        String userWikittyId = client.findByQuery(String.class, query);
        return userWikittyId;
    }

    @Deprecated
    public static WikittyGroup createAppAdminGroup(WikittyUser user) {
        WikittyGroupImpl result = new WikittyGroupImpl();
        result.setName(WIKITTY_APPADMIN_GROUP_NAME);
        String firstUserId = user.getWikittyId();
        result.addMembers(firstUserId);
        return result;
    }

    public static Wikitty createExtensionAuthorisation(WikittyUser owner, WikittyExtension extension) {
        String wikittyAuthorisationId = WikittyMetaExtensionUtil.generateId("WikittyAuthorisation", extension.getName());
        WikittyImpl result = new WikittyImpl(wikittyAuthorisationId);
        WikittyAuthorisationHelper.addExtension(result);
        WikittyAuthorisationHelper.setOwner((Wikitty)result, owner.getWikittyId());
        return result;
    }

    @Deprecated
    public static Wikitty restoreExtensionAuthorisation(WikittyProxy proxy, WikittyExtension extension) {
        String wikittyAuthorisationId = WikittyMetaExtensionUtil.generateId("WikittyAuthorisation", extension.getName());
        Wikitty result = proxy.restore(wikittyAuthorisationId);
        return result;
    }

    public static Wikitty restoreExtensionAuthorisation(WikittyClient client, WikittyExtension extension) {
        String wikittyAuthorisationId = WikittyMetaExtensionUtil.generateId("WikittyAuthorisation", extension.getName());
        Wikitty result = client.restore(wikittyAuthorisationId, new String[0]);
        return result;
    }
}

