/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.addons.importexport;

import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyClient;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.addons.WikittyImportExportService;
import org.nuiton.wikitty.addons.importexport.ImportExportMethod;
import org.nuiton.wikitty.addons.importexport.ImportTask;
import org.nuiton.wikitty.entities.Element;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryResult;

public class ExportQueryTask
implements Runnable {
    private static Log log = LogFactory.getLog(ImportTask.class);
    protected WikittyClient client;
    protected WikittyImportExportService.FORMAT format;
    protected WikittyQuery query;
    protected Writer writer;

    public ExportQueryTask(WikittyClient client, WikittyImportExportService.FORMAT format, WikittyQuery query, Writer writer) {
        this.client = client;
        this.format = format;
        this.query = query;
        this.writer = writer;
    }

    @Override
    public void run() {
        try {
            this.query.addFacetField(Element.EXTENSION);
            WikittyQueryResult<Wikitty> queryResult = this.client.findAllByQuery(Wikitty.class, this.query);
            long time = 0L;
            if (log.isInfoEnabled()) {
                time = System.currentTimeMillis();
                log.info((Object)"Export started");
            }
            ImportExportMethod exporter = this.format.ieporter();
            exporter.exportWriter(this.client, this.writer, queryResult);
            if (log.isInfoEnabled()) {
                time = System.currentTimeMillis() - time;
                log.info((Object)("Export in (ms)" + time));
            }
        }
        catch (Exception eee) {
            throw new WikittyException("Error during export task", eee);
        }
    }
}

