package org.nuiton.wikitty.query.function;

/*
 * #%L
 * Wikitty :: api
 * $Id: FunctionMax.java 1554 2013-02-25 00:57:54Z bpoussin $
 * $HeadURL: http://svn.nuiton.org/wikitty/tags/wikitty-3.11/wikitty-api/src/main/java/org/nuiton/wikitty/query/function/FunctionMax.java $
 * %%
 * Copyright (C) 2009 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.query.ListObjectOrMap;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.services.WikittyTransaction;
import org.nuiton.wikitty.storage.WikittySearchEngine;

/**
 *
 * @author poussin
 * @version $Revision: 1554 $
 *
 * Last update: $Date: 2013-02-25 01:57:54 +0100 (Mon, 25 Feb 2013) $
 * by : $Author: bpoussin $
 */
public class FunctionMax extends WikittyQueryFunction {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(FunctionMax.class);

    public FunctionMax(String name) {
        super("Max", name, null);
    }

    public FunctionMax(String name, WikittyQueryFunction arg) {
        super("Max", name, Collections.singletonList(arg));
    }

    public FunctionMax(String methodName, String name, List<WikittyQueryFunction> args) {
        super(methodName, name, args);
        if (args.size() != 1) {
            throw new IllegalArgumentException("Sum accept only one argument");
        }
    }

    @Override
    public int getNumArg() {
        return 1;
    }

    @Override
    public List<Map<String, Object>> call(
            WikittyQuery query, List<Map<String, Object>> data) {
        
        WikittyQueryFunction f = getArgs().get(0);
        data = f.call(query, data);

        Comparable candidate = null;
        for (Map<String, Object> m : data) {
            Object v = getUniqueValue(m);
            if (v instanceof Collection) {
                for (Object o : (Collection)v) {
                    if (o instanceof Comparable) {
                        if (candidate == null || candidate.compareTo(o) < 0) {
                            candidate = (Comparable)o;
                        }
                    }
                }
            } else {
                if (v instanceof Comparable) {
                    if (candidate == null || candidate.compareTo(v) < 0) {
                        candidate = (Comparable)v;
                    }
                }
            }
        }

        ListObjectOrMap result = new ListObjectOrMap();
        result.add(getName(), candidate);
        return result;
    }
}
