/*
 * #%L
 * Wikitty :: api
 * 
 * $Id: ImportTask.java 659 2010-12-24 10:21:27Z sletellier $
 * $HeadURL: http://svn.nuiton.org/svn/wikitty/tags/wikitty-3.1.1/wikitty-api/src/main/java/org/nuiton/wikitty/addons/importexport/ImportTask.java $
 * %%
 * Copyright (C) 2009 - 2010 CodeLutin, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.wikitty.addons.importexport;

import java.io.Reader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.addons.WikittyImportExportService.FORMAT;
import org.nuiton.wikitty.services.WikittyServiceTransaction;

public class ImportTask implements Runnable {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(ImportTask.class);

    protected ApplicationConfig config;
    protected WikittyService ws;
    protected FORMAT format;
    protected Reader reader;
    protected ImportExportMethod importerExporter;
    protected String securityToken;

    public ImportTask(String securityToken, ApplicationConfig config,
            WikittyService ws, FORMAT format, Reader reader) {
        super();
        this.config = config;
        this.securityToken = securityToken;
        this.ws = ws;
        this.format = format;
        this.reader = reader;
    }

    @Override
    public void run() {
        WikittyServiceTransaction tx = new WikittyServiceTransaction(config, ws);
        // TODO poussin 20101029 rendre configurable le l'auto commit '1000' pour l'import
        tx.setAutoCommit(1000);
        try {
            long time = 0;
            if (log.isInfoEnabled()) {
                time = System.currentTimeMillis();
                log.info("Import in (ms)" + time);
            }
            ImportExportMethod importer = format.ieporter();
            importer.importReader(securityToken, reader, tx);

            if (log.isInfoEnabled()) {
                time = System.currentTimeMillis() - time;
                log.info("Import in (ms)" + time);
            }
            // don't forget to commit :)
            // FIXME sletellier 24/12/10 : provoque an wikitty is obselete
//            tx.commit(securityToken);
            tx.commit(securityToken, true);
        } catch (Exception eee) {
            tx.rollback(securityToken);
            throw new WikittyException("Error during import task", eee);
        }
    }
}
