/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyConfig;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceFactory;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.services.WikittyServiceCajoClient;
import org.nuiton.wikitty.services.WikittyServiceCajoServer;
import org.nuiton.wikitty.services.WikittyServiceInMemory;

public class WikittyServiceCajoTest {
    private static Log log = LogFactory.getLog(WikittyServiceCajoTest.class);
    protected static final String url = "http://localhost:1198/ws";

    protected WikittyService startServer() throws Exception {
        Properties props = new Properties();
        props.setProperty(WikittyConfig.WikittyOption.WIKITTY_SERVER_URL.getKey(), url);
        props.setProperty(WikittyConfig.WikittyOption.WIKITTY_WIKITTYSERVICE_COMPONENTS.getKey(), WikittyServiceInMemory.class.getName() + "," + WikittyServiceCajoServer.class.getName());
        WikittyConfig config = new WikittyConfig(props);
        WikittyService result = WikittyServiceFactory.buildWikittyService((ApplicationConfig)config);
        return result;
    }

    protected void stopServer(WikittyService ws) {
        if (ws instanceof WikittyServiceCajoServer) {
            ((WikittyServiceCajoServer)ws).stop();
        }
    }

    protected WikittyService getClient() throws Exception {
        Properties props = new Properties();
        props.setProperty(WikittyConfig.WikittyOption.WIKITTY_SERVER_URL.getKey(), url);
        props.setProperty(WikittyConfig.WikittyOption.WIKITTY_WIKITTYSERVICE_COMPONENTS.getKey(), WikittyServiceCajoClient.class.getName());
        WikittyConfig config = new WikittyConfig(props);
        WikittyService result = WikittyServiceFactory.buildWikittyService((ApplicationConfig)config);
        return result;
    }

    @Test
    public void testCajo() throws Exception {
        WikittyService server = this.startServer();
        WikittyService client = this.getClient();
        WikittyProxy proxy = new WikittyProxy(client);
        WikittyImpl w = new WikittyImpl();
        proxy.store((Wikitty)w);
        List list = server.restore(null, Collections.singletonList(w.getId()));
        Assert.assertEquals((long)1L, (long)list.size());
        this.stopServer(server);
    }
}

