/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.addons;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyConfig;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.addons.WikittyI18nImpl;
import org.nuiton.wikitty.addons.WikittyI18nUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyI18n;
import org.nuiton.wikitty.entities.WikittyLabelImpl;
import org.nuiton.wikitty.services.WikittyServiceInMemory;

public class WikittyI18nTest {
    private static Log log = LogFactory.getLog(WikittyI18nTest.class);

    @Test
    public void testI18n() throws Exception {
        WikittyConfig config = new WikittyConfig();
        WikittyServiceInMemory ws = new WikittyServiceInMemory((ApplicationConfig)config);
        WikittyProxy proxy = new WikittyProxy((WikittyService)ws);
        WikittyLabelImpl label = new WikittyLabelImpl();
        Wikitty labelWikitty = WikittyUtil.getWikitty((WikittyService)ws, null, (BusinessEntity)label);
        WikittyExtension ext = labelWikitty.getExtension("WikittyLabel");
        WikittyI18n i18n = WikittyI18nUtil.getI18n((WikittyProxy)proxy, (WikittyExtension)ext);
        i18n.setTranslation("fr", "labels", "\u00e9tiquette");
        proxy.store((BusinessEntity)i18n);
        String trad = i18n.getTranslation("fr", "labels");
        Assert.assertEquals((Object)"\u00e9tiquette", (Object)trad);
        Assert.assertEquals((long)1L, (long)i18n.getLang().size());
        Assert.assertEquals((Object)"fr", i18n.getLang().iterator().next());
        Assert.assertEquals((Object)"[fr:\"labels\"=\"\u00e9tiquette\"]", (Object)i18n.getTranslations());
        i18n.setTranslation("es", "labels", "etiqueta");
        Assert.assertEquals((long)2L, (long)i18n.getLang().size());
        ((WikittyI18nImpl)i18n).translationsCache = null;
        trad = i18n.getTranslation("fr", "labels");
        Assert.assertEquals((Object)"\u00e9tiquette", (Object)trad);
    }
}

