package org.nuiton.wikitty.search;

import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

/**
 * @author "Nicolas Chapurlat" <nicolas.chapurlat@logica.com>
 * 
 * This class allow you to simply create restriction.
 * <p/>
 * Examples :
 * <pre>
 * RestrictionHelper.and(
 *    RestrictionHelper.eq(
 *       new ElementDto(ElementName.CONTENT_DEFINITION, OperandName.ID, OperandType.ID), "myContentDefId"),
 *    RestrictionHelper.between(
 *       new ElementDto(ElementName.CONTENT, OperandName.CREATION_DATE, OperandType.DATE),
 *       RestrictionHelper.DATE_FORMAT.format (new Date(2008,1,25)),
 *       RestrictionHelper.DATE_FORMAT.format (new Date(2008,6,15))))
 * ); 
 * </pre>
 * <p/>
 * example 2 : I search all content witch content definition id is
 * "myContentDefId" and attribute def 'ref' witch id is ATT_REF_ID is not equals
 * to "REF1234567890"
 * <pre>
 * RestrictionHelper.and(
 *    RestrictionHelper.eq(
 *       new ElementDto(ElementName.CONTENT_DEFINITION, OperandName.ID, OperandType.ID), "myContentDefId"),
 *    RestrictionHelper.neq(
 *       new ElementDto(ElementName.ATTRIBUTE, "ATT_REF_ID", OperandType.STRING), "REF1234567890"))
 * );
 * </pre>
 */
public class RestrictionHelper {

    public static Restriction eq(Element element, String value) {
        Equals eq = new Equals();
        eq.setName(RestrictionName.EQUALS);
        eq.setElement(element);
        eq.setValue(value);
        return eq;
    }

    public static Restriction like(Element element, String value, Like.SearchAs searchAs) {
        Like like = new Like();
        like.setName(RestrictionName.LIKE);
        like.setElement(element);
        like.setValue(value);
        like.setSearchAs(searchAs);
        return like;
    }

    public static Restriction unlike(Element element, String value, Like.SearchAs searchAs) {
        Unlike unlike = new Unlike();
        unlike.setName(RestrictionName.UNLIKE);
        unlike.setElement(element);
        unlike.setValue(value);
        unlike.setSearchAs(searchAs);
        return unlike;
    }

    public static Restriction neq(Element element, String value) {
        NotEquals neq = new NotEquals();
        neq.setName(RestrictionName.NOT_EQUALS);
        neq.setElement(element);
        neq.setValue(value);
        return neq;
    }

    public static Restriction less(Element element, String value) {
        Less less = new Less();
        less.setName(RestrictionName.LESS);
        less.setElement(element);
        less.setValue(value);
        return less;
    }

    public static Restriction lessEq(Element element, String value) {
        LessOrEqual lessEq = new LessOrEqual();
        lessEq.setName(RestrictionName.LESS_OR_EQUAL);
        lessEq.setElement(element);
        lessEq.setValue(value);
        return lessEq;
    }

    public static Restriction great(Element element, String value) {
        Greater great = new Greater();
        great.setName(RestrictionName.GREATER);
        great.setElement(element);
        great.setValue(value);
        return great;
    }

    public static Restriction greatEq(Element element, String value) {
        GreaterOrEqual greatEq = new GreaterOrEqual();
        greatEq.setName(RestrictionName.GREATER_OR_EQUAL);
        greatEq.setElement(element);
        greatEq.setValue(value);
        return greatEq;
    }

    public static Restriction start(Element element, String value) {
        StartsWith start = new StartsWith();
        start.setName(RestrictionName.STARTS_WITH);
        start.setElement(element);
        start.setValue(value);
        return start;
    }

    public static Restriction end(Element element, String value) {
        EndsWith end = new EndsWith();
        end.setName(RestrictionName.ENDS_WITH);
        end.setElement(element);
        end.setValue(value);
        return end;
    }

    public static Restriction between(Element element, String min,
            String max) {
        Between between = new Between(element, min, max);
        between.setName(RestrictionName.BETWEEN);
        return between;
    }

    public static Restriction contains(Element element, String value1,
            String... otherValues) {
        List<String> values = new LinkedList<String>();
        values.add(value1);
        for (String val : otherValues) {
            values.add(val);
        }
        return contains(element, values);
    }

    public static Contains contains(Element element,
            List<String> values) {
        Contains contains = new Contains(element, values);
        contains.setName(RestrictionName.CONTAINS);
        return contains;
    }

    public static Restriction not(Restriction restriction) {
        Not not = new Not(restriction);
        not.setName(RestrictionName.NOT);
        return not;
    }

    public static Restriction and(Restriction restriction1,
            Restriction restriction2, Restriction... otherRestrictions) {
        List<Restriction> restrictions = new LinkedList<Restriction>();
        restrictions.add(restriction1);
        restrictions.add(restriction2);
        for (Restriction rest : otherRestrictions) {
            restrictions.add(rest);
        }
        return and(restrictions);
    }

    public static And and(List<Restriction> restrictions) {
        And and = new And(restrictions);
        and.setName(RestrictionName.AND);
        return and;
    }

    public static Or or(Restriction restriction1,
            Restriction restriction2, Restriction... otherRestrictions) {
        List<Restriction> restrictions = new LinkedList<Restriction>();
        restrictions.add(restriction1);
        restrictions.add(restriction2);
        for (Restriction rest : otherRestrictions) {
            restrictions.add(rest);
        }
        return or(restrictions);
    }

    public static Or or(List<Restriction> restrictions) {
        Or or = new Or(restrictions);
        or.setName(RestrictionName.OR);
        return or;
    }

    public static Restriction rTrue() {
        Restriction rTrue = new Restriction();
        rTrue.setName(RestrictionName.TRUE);
        return rTrue;
    }

    public static Restriction rFalse() {
        Restriction rFalse = new Restriction();
        rFalse.setName(RestrictionName.FALSE);
        return rFalse;
    }

    public static Keyword keyword(String value) {
        Keyword keyword = new Keyword();
        keyword.setName(RestrictionName.KEYWORD);
        keyword.setValue(value);
        return keyword;
    }

    static ThreadLocal<SimpleDateFormat> myFormats = new ThreadLocal<SimpleDateFormat>() {
        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat ret = new SimpleDateFormat(
                    "yyyy-MM-dd'T'00:00:00.000'Z/DAY'", Locale.US);
            ret.setTimeZone(TimeZone.getTimeZone("UTC"));
            return ret;
        }
    };

    public static SimpleDateFormat getDateFormat() {
        return myFormats.get();
    }
}
