package org.nuiton.wikitty.importexport;

import java.io.Reader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyTransaction;
import org.nuiton.wikitty.WikittyImportExportService.FORMAT;

public class ImportTask implements Runnable {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(ImportTask.class);

    protected WikittyService ws;
    protected WikittyTransaction transaction;
    protected FORMAT format;
    protected Reader reader;
    protected ImportExportMethod importerExporter;
    protected String securityToken;

    public ImportTask(String securityToken,
            WikittyService ws, FORMAT format, Reader reader) {
        super();
        this.securityToken = securityToken;
        this.ws = ws;
        this.format = format;
        this.reader = reader;
        this.transaction = new WikittyTransaction();
    }

    @Override
    public void run() {
        try {
            transaction.begin();
            WikittyBatchUpdate batchUpdate = new WikittyBatchUpdate(
                    securityToken, ws, transaction);
            
            long time = 0;
            if (log.isInfoEnabled()) {
                time = System.currentTimeMillis();
                log.info("Import in (ms)" + time);
            }
            ImportExportMethod importer = format.ieporter();
            importer.importReader(securityToken, reader, ws, transaction, batchUpdate);

            if (log.isInfoEnabled()) {
                time = System.currentTimeMillis() - time;
                log.info("Import in (ms)" + time);
            }
            // don't forget to flush batchUpdate :)
            batchUpdate.flush();
            transaction.commit();
        } catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException(eee);
        }
    }
}
