package org.nuiton.topia.templates;

/*
 * #%L
 * ToPIA :: Templates
 * $Id: TopiaTagValues.java 2955 2013-12-20 16:19:35Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-3.0-alpha-8/topia-templates/src/main/java/org/nuiton/topia/templates/TopiaTagValues.java $
 * %%
 * Copyright (C) 2004 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import org.nuiton.eugene.EugeneTagValues;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.topia.persistence.internal.AbstractTopiaApplicationContext;
import org.nuiton.topia.persistence.internal.AbstractTopiaPersistenceContext;
import org.nuiton.topia.persistence.TopiaDaoSupplier;
import org.nuiton.topia.persistence.internal.AbstractTopiaDao;
import org.nuiton.topia.persistence.TopiaDao;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.TopiaEntityContextable;

import static org.nuiton.eugene.ModelPropertiesUtil.TagValueDefinition;

/**
 * All extra tag values usable in topia generators.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.5
 */
public interface TopiaTagValues extends EugeneTagValues {

    /**
     * Tag pour le type de persistence.
     *
     * @see TopiaGeneratorUtil#getPersistenceType(ObjectModelClassifier)
     * @see TopiaGeneratorUtil#getPersistenceTypeTagValue(ObjectModelClassifier)
     * @since 2.5
     */
    @TagValueDefinition(target = {ObjectModelClassifier.class},
                        documentation = "")
    String TAG_PERSISTENCE_TYPE = "persistenceType";

    /**
     * Tag pour que les entités etendent {@link TopiaEntityContextable} et
     * se fasse injecter le {@link TopiaDaoSupplier} par rapport aux autres
     * entités qui ne l'ont pas.
     *
     * @since 2.5.3
     */
    @TagValueDefinition(target = {ObjectModelClassifier.class}, documentation = "")
    String TAG_CONTEXTABLE = "contextable";

    /**
     * Tag pour le nom du champ / entité en BD.
     *
     * @see TopiaGeneratorUtil#getDbNameTagValue(ObjectModelElement)
     * @see TopiaGeneratorUtil#getDbName(ObjectModelElement)
     * @see TopiaGeneratorUtil#getReverseDbName(ObjectModelAttribute)
     */
    @TagValueDefinition(target = {ObjectModelElement.class},
                        documentation = "Sets the database name of an element of the model (a table or a column)")
    String TAG_DB_NAME = "dbName";

    /**
     * Tag pour le nom du schema en BD.
     *
     * @see TopiaGeneratorUtil#getDbSchemaNameTagValue(ObjectModelClassifier, ObjectModel)
     * @see TopiaGeneratorUtil#getDbSchemaNameTagValue(ObjectModelAttribute, ObjectModel)
     * @since 2.5
     */
    @TagValueDefinition(target = {ObjectModel.class, ObjectModelClassifier.class, ObjectModelAttribute.class},
                        documentation = "Sets the database schema name")
    String TAG_SCHEMA_NAME = "dbSchema";

    /**
     * Tag pour la taille du champ en BD.
     *
     * @see TopiaGeneratorUtil#getLengthTagValue(ObjectModelAttribute)
     * @since 2.5
     */
    @TagValueDefinition(target = {ObjectModelAttribute.class},
                        documentation = "Sets the length of an attribute in database")
    String TAG_LENGTH = "length";

    /**
     * Tag pour ajouter une annotation à un champ.
     *
     * @see TopiaGeneratorUtil#getAnnotationTagValue(ObjectModelAttribute)
     * @since 2.5
     */
    @TagValueDefinition(target = {ObjectModelAttribute.class},
                        documentation = "Sets an annotation of an attribute")
    String TAG_ANNOTATION = "annotation";

    /**
     * Tag pour specfier le type d'acces a un champ.
     *
     * @see TopiaGeneratorUtil#getAccessTagValue(ObjectModelAttribute)
     * @since 2.5
     */
    @TagValueDefinition(target = {ObjectModelAttribute.class},
                        documentation = "Sets the access type of an attribute (Hibernate mapping)")
    String TAG_ACCESS = "access";

    /**
     * Tag pour ajouter un attribut dans une clef métier.
     *
     * @see TopiaGeneratorUtil#getNaturalIdTagValue(ObjectModelAttribute)
     * @see TopiaGeneratorUtil#isNaturalId(ObjectModelAttribute)
     * @since 2.5
     */
    @TagValueDefinition(target = {ObjectModelAttribute.class},
                        documentation = "Sets an attribute as part of a natural id (Hibernate Mapping)")
    String TAG_NATURAL_ID = "naturalId";

    /**
     * Tag pour specifier si une clef metier est mutable.
     *
     * @see TopiaGeneratorUtil#getNaturalIdMutableTagValue(ObjectModelClassifier)
     * @see TopiaGeneratorUtil#isNaturalIdMutable(ObjectModelClass)
     * @since 2.5
     */
    @TagValueDefinition(target = {ObjectModelClassifier.class},
                        documentation = "Sets if natural id of a entity is mutable (hibernate mapping)")
    String TAG_NATURAL_ID_MUTABLE = "naturalIdMutable";

    /**
     * Tag pour permettre de choisir qui contrôle la relation N-N
     * bidirectionnelle. A utiliser sur les deux extremités de l'association.
     * Mettre inverse=false sur le rôle fils et inverse=true sur le rôle père.
     * Par défaut le inverse=true est placé sur le premier rôle trouvé dans
     * l'ordre alphabétique.
     *
     * @see TopiaGeneratorUtil#getInverseTagValue(ObjectModelAttribute)
     * @since 2.5
     */
    @TagValueDefinition(target = {ObjectModelAttribute.class},
                        documentation = "Sets which part of a N-N relation is master (inverse=true) and slave (inverse=false) (must be put on each side on a such relation) (Hibernate mapping)")
    String TAG_INVERSE = "inverse";

    /**
     * Tag pour spécifier la caractère lazy d'une association multiple.
     *
     * @see TopiaGeneratorUtil#getLazyTagValue(ObjectModelAttribute)
     * @since 2.5
     */
    @TagValueDefinition(target = {ObjectModelAttribute.class},
                        documentation = "Sets if an association should be lazy (Hibernate mapping)")
    String TAG_LAZY = "lazy";

    /**
     * Tag pour spécifier la caractère fetch d'une association multiple.
     *
     * @see TopiaGeneratorUtil#getFetchTagValue(ObjectModelAttribute)
     * @since 2.5
     */
    @TagValueDefinition(target = {ObjectModelAttribute.class},
                        documentation = "Sets the fetch caracteristic of an attribute (Hibernate mapping)")
    String TAG_FETCH = "fetch";

    /**
     * Tag pour spécifier la caractère order-by d'une association multiple.
     *
     * @see TopiaGeneratorUtil#getOrderByTagValue(ObjectModelAttribute)
     * @since 2.5
     */
    @TagValueDefinition(target = {ObjectModelAttribute.class},
                        documentation = "Sets the order by propertie of an multiple association (Hibernate mapping)")
    String TAG_ORDER_BY = "orderBy";

    /**
     * Tag pour spécifier la caractère not-null d'un attribut.
     *
     * @see TopiaGeneratorUtil#getNotNullTagValue(ObjectModelAttribute)
     * @since 2.5
     */
    @TagValueDefinition(target = {ObjectModelAttribute.class},
                        documentation = "Sets if an attribute must be not null (Hibernate mapping)")
    String TAG_NOT_NULL = "notNull";

    /**
     * Tag à placer sur un l'attribut d'une entité. Cet attribut est de type
     * énumération : l'ajout de la tagValue indique qu'il faut utiliser le
     * {@code name} de l'énumération et non l'ordinal pour stocker la valeur en
     * base
     */
    @TagValueDefinition(target = {ObjectModelAttribute.class},
                        documentation = "'true' if the value of this attribute of type Enumeration should be stored with its name (instead of using ordinal)")
    String TAG_USE_ENUMERATION_NAME = "useEnumerationName";

    /**
     * Tag pour configurer l'interface du proxy sur autre chose que l'implementation par defaut.
     * <p/>
     * Par defaut :
     * null > generere le proxy sur l'interface de l'implementation
     * Autre valeur :
     * "none" > laisse la configuration par defaut d'hibernate
     *
     * @see TopiaGeneratorUtil#getPersistenceTypeTagValue(ObjectModelClassifier)
     * @since 2.5
     */
    @TagValueDefinition(target = {ObjectModel.class, ObjectModelClassifier.class},
                        documentation = "Configure the proxy interface on something else than the default implementation (null to use our default implementation, none to let hibernate deal it) (Hibernate mapping)")
    String TAG_PROXY_INTERFACE = "hibernateProxyInterface";

    /**
     * Tag pour configurer la stategie d'heritage choisie.
     * <p/>
     * Par defaut : union-subclass : Table per class strategy
     * Autre valeur :
     * "subclass" > Single table per class hierarchy strategy
     * "joined-subclass" > Joined subclass strategy
     *
     * @see TopiaGeneratorUtil#getPersistenceTypeTagValue(ObjectModelClassifier)
     * @since 3.0
     */
    @TagValueDefinition(target = {ObjectModel.class, ObjectModelClassifier.class},
                        documentation = "Configure the proxy interface on something else than the default implementation (null to use our default implementation, none to let hibernate deal it) (Hibernate mapping)")
    String TAG_INHERITANCE_STRATEGY = "inheritanceStrategy";

    /**
     * Tag pour specifier de ne pas generer la methode toString.
     *
     * @see TopiaGeneratorUtil#getNotGenerateToStringTagValue(ObjectModelClassifier, ObjectModel)
     * @see TopiaGeneratorUtil#generateToString(ObjectModelClass, ObjectModel)
     * @since 2.5
     */
    @TagValueDefinition(target = {ObjectModel.class, ObjectModelClassifier.class},
                        documentation = "To not generate the toString method on entities")
    String TAG_NOT_GENERATE_TO_STRING = "notGenerateToString";

    /**
     * Tag pour specifier de trier les attributs par nom lors de la generation.
     *
     * @see TopiaGeneratorUtil#getSortAttributeTagValue(ObjectModelClassifier, ObjectModel)
     * @see TopiaGeneratorUtil#sortAttribute(ObjectModelClass, ObjectModel)
     * @since 2.5
     */
    @TagValueDefinition(target = {ObjectModel.class, ObjectModelClassifier.class},
                        documentation = "To sort attribute while generation")
    String TAG_SORT_ATTRIBUTE = "sortAttribute";

    /**
     * Tag pour specfier si on doit générer la methode getOperator dans les daohelpers.
     *
     * @see TopiaGeneratorUtil#getGenerateOperatorForDAOHelperTagValue(ObjectModel)
     * @see TopiaGeneratorUtil#shouldGenerateOperatorForDAOHelper(ObjectModel)
     * @since 2.5
     */
    @TagValueDefinition(target = {ObjectModel.class},
                        documentation = "To generate EntityOperation on generated DAOHelper")
    String TAG_GENERATE_OPERATOR_FOR_DAO_HELPER = "generateOperatorForDAOHelper";

    /**
     * Tag pour spécifier le type d'une propriété dans le mapping hibernate.
     *
     * @see TopiaGeneratorUtil#getTypeTagValue(ObjectModelAttribute)
     * @since 2.5
     */
    @TagValueDefinition(target = {ObjectModelAttribute.class},
                        documentation = "Sets the hibernate type of an attribute (Hibernate mapping)")
    String TAG_TYPE = "type";

    /**
     * Tag pour spécifier le type sql d'une propriété dans le mapping hibernate.
     *
     * @see TopiaGeneratorUtil#getSqlTypeTagValue(ObjectModelAttribute)
     * @since 2.5
     */
    @TagValueDefinition(target = {ObjectModelAttribute.class},
                        documentation = "Sets the sql type of an attribute (Hibernate mapping)")
    String TAG_SQL_TYPE = "sqlType";

    /**
     * To specify the abstract dao to use.
     * <p/>
     * If none given, will use the {@code org.nuiton.topia.persistence.TopiaDAOImpl}.
     * <p/>
     * Other value possible is {@code org.nuiton.topia.persistence.TopiaDAOLegacy}
     *
     * @see TopiaGeneratorUtil#getDaoImplementationTagValue(ObjectModel)
     * @since 2.5
     */
    @TagValueDefinition(target = {ObjectModel.class},
                        documentation = "Sets the fully qualified name of the DAO implementation to use in generated DAO (default is DAOImpl (base on TopiaQuery))")
    String TAG_DAO_IMPLEMENTATION = "daoImplementation";

    /**
     * Stéréotype pour les attributs avec multiplicité nécessitant la création d'un index.
     *
     * @see TopiaGeneratorUtil#getIndexForeignKeys(ObjectModelAttribute, ObjectModel)
     * @since 2.6.5
     */
    @TagValueDefinition(target = {ObjectModel.class, ObjectModelAttribute.class},
                        documentation = "Specifies if an nm-multiplicity attribute (or all nm-multiplicity attributes of a given model) needs an index in db (Hibernate mapping)")
    String TAG_INDEX_FOREIGN_KEYS = "indexForeignKeys";

    /**
     * Tag to specify if we want to add an "id" property in DTO generated by
     * {@link EntityDTOTransformer}.
     * <p/>
     *
     * @see EntityDTOTransformer
     * @see TopiaGeneratorUtil#shouldGenerateDTOTopiaIdTagValue(ObjectModelClassifier, ObjectModel)
     * @since 2.6.7
     */
    @TagValueDefinition(target = {ObjectModel.class, ObjectModelClassifier.class},
                        documentation = "Add a \"id\" property with its getter/setter on a DTO.")
    String TAG_GENERATE_TOPIA_ID_IN_DTO = "generateDTOTopiaId";


    /**
     * Tag to specify a super class to use instead of {@link AbstractTopiaPersistenceContext}.
     * <p/>
     * <strong>Note:</strong> the class must implements {@link AbstractTopiaPersistenceContext}.
     *
     * @see AbstractTopiaPersistenceContext
     * @see TopiaGeneratorUtil#getPersistenceContextSuperClassTagValue(ObjectModel)}
     * @since 3.0
     */
    @TagValueDefinition(target = {ObjectModel.class},
                        documentation = "Change the super class to use when generating PersistenceContext.")
    String TAG_PERSISTENCE_CONTEXT_SUPER_CLASS = "persistenceContextSuperClass";

    /**
     * Tag to specify a super class to use instead of {@link AbstractTopiaApplicationContext}.
     * <p/>
     * <strong>Note:</strong> the class must implements {@link AbstractTopiaApplicationContext}.
     *
     * @see AbstractTopiaApplicationContext
     * @see TopiaGeneratorUtil#getApplicationContextSuperClassTagValue(ObjectModel)}
     * @since 3.0
     */
    @TagValueDefinition(target = {ObjectModel.class},
                        documentation = "Change the super class to use when generating ApplicationContext.")
    String TAG_APPLICATION_CONTEXT_SUPER_CLASS = "applicationContextSuperClass";

    /**
     * Tag to specify a super class to use instead of {@link AbstractTopiaDao}.
     * <p/>
     * <strong>Note:</strong> the class must implements {@link TopiaDao}.
     *
     * @see AbstractTopiaDao
     * @see TopiaGeneratorUtil#getDaoSuperClassTagValue(ObjectModelClassifier, ObjectModel)}
     * @since 3.0
     */
    @TagValueDefinition(target = {ObjectModelClassifier.class, ObjectModel.class},
                        documentation = "Change the super class to use when generating dao.")
    String TAG_DAO_SUPER_CLASS= "daoSuperClass";

    /**
     * Tag to specify a super class to use instead of {@link TopiaEntityAbstract}.
     * <p/>
     * <strong>Note:</strong> the class must implements {@link TopiaEntity}.
     *
     * @see TopiaEntity
     * @see TopiaGeneratorUtil#getEntitySuperClassTagValue(ObjectModelClassifier, ObjectModel)}
     * @since 3.0
     */
    @TagValueDefinition(target = {ObjectModelClassifier.class, ObjectModel.class},
                        documentation = "Change the super class to use when generating Entity.")
    String TAG_ENTITY_SUPER_CLASS= "entitySuperClass";
}
