package org.nuiton.topia.security.entities.authorization;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class TopiaExpressionLinkAbstract extends TopiaEntityAbstract implements TopiaExpressionLink {

    public String replace;
    public String by;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TopiaExpressionLink.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(TopiaExpressionLink.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "replace", String.class, replace);
        visitor.visit(this, "by", String.class, by);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setReplace :
     * @param value 
     */

    public void setReplace(String value) {
        String _oldValue = this.replace;
        fireOnPreWrite("replace", _oldValue, value);
        this.replace = value;
        fireOnPostWrite("replace", _oldValue, value);
}

    /**
     * getReplace :
     * @return String 
     */

    public String getReplace() {
        fireOnPreRead("replace", replace);
        String result = this.replace;
        fireOnPostRead("replace", replace);
        return result;
}

    /**
     * setBy :
     * @param value 
     */

    public void setBy(String value) {
        String _oldValue = this.by;
        fireOnPreWrite("by", _oldValue, value);
        this.by = value;
        fireOnPostWrite("by", _oldValue, value);
}

    /**
     * getBy :
     * @return String 
     */

    public String getBy() {
        fireOnPreRead("by", by);
        String result = this.by;
        fireOnPostRead("by", by);
        return result;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("replace", this.replace).
            append("by", this.by).
         toString();
        return result;
}


} //TopiaExpressionLinkAbstract
