/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.replication.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.util.EntityOperator;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.topia.persistence.util.TopiaEntityIdsMap;
import org.nuiton.topia.replication.TopiaReplicationOperation;
import org.nuiton.topia.replication.model.ReplicationLink;
import org.nuiton.topia.replication.model.ReplicationNode;
import org.nuiton.topia.replication.model.ReplicationOperationDef;
import org.nuiton.topia.replication.model.ReplicationOperationPhase;
import org.nuiton.topia.replication.operation.AttachLink;
import org.nuiton.topia.replication.operation.DettachAssociation;
import org.nuiton.topia.replication.operation.Duplicate;
import org.nuiton.topia.replication.operation.LoadLink;

public class ReplicationModel {
    private static final Log log = LogFactory.getLog(ReplicationModel.class);
    protected final TopiaEntityEnum[] contracts;
    protected final String[] topiaIds;
    protected final Map<TopiaEntityEnum, ReplicationNode> nodes;
    protected final List<ReplicationNode> order;
    protected final boolean replicateAll;

    public ReplicationModel(TopiaEntityEnum[] contracts, Set<Class<? extends TopiaEntity>> types, String ... topiaIds) {
        this.contracts = (TopiaEntityEnum[])contracts.clone();
        this.topiaIds = topiaIds;
        this.replicateAll = false;
        this.order = new ArrayList<ReplicationNode>();
        HashMap<TopiaEntityEnum, ReplicationNode> tmpNodes = new HashMap<TopiaEntityEnum, ReplicationNode>();
        for (Class<? extends TopiaEntity> k : types) {
            TopiaEntityEnum e = this.getContract(k);
            ReplicationNode replicationNode = new ReplicationNode(e);
            tmpNodes.put(e, replicationNode);
        }
        this.nodes = Collections.unmodifiableMap(tmpNodes);
    }

    public ReplicationModel(TopiaEntityEnum[] contracts, boolean replicateAll, String ... topiaIds) {
        this.contracts = (TopiaEntityEnum[])contracts.clone();
        this.topiaIds = topiaIds;
        this.replicateAll = replicateAll;
        this.order = new ArrayList<ReplicationNode>();
        HashMap<TopiaEntityEnum, ReplicationNode> tmpNodes = new HashMap<TopiaEntityEnum, ReplicationNode>();
        for (TopiaEntityEnum e : contracts) {
            ReplicationNode replicationNode = new ReplicationNode(e);
            tmpNodes.put(e, replicationNode);
            if (replicateAll) continue;
            this.order.add(replicationNode);
        }
        this.nodes = Collections.unmodifiableMap(tmpNodes);
    }

    public TopiaEntityEnum getContract(Class<?> type) {
        TopiaEntityEnum e = null;
        if (TopiaEntity.class.isAssignableFrom(type)) {
            e = TopiaEntityHelper.getEntityEnum(type, (TopiaEntityEnum[])this.contracts);
        }
        return e;
    }

    public Collection<ReplicationNode> getNodes() {
        return this.nodes.values();
    }

    public Set<Class<? extends TopiaEntity>> getTypes() {
        HashSet<Class<? extends TopiaEntity>> result = new HashSet<Class<? extends TopiaEntity>>();
        for (TopiaEntityEnum e : this.nodes.keySet()) {
            result.add(e.getContract());
        }
        return result;
    }

    public ReplicationNode getNode(TopiaEntityEnum contract) {
        return this.nodes.get(contract);
    }

    public void addDependency(List<ReplicationNode> nodes) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Try to add nodes : " + String.valueOf(nodes) + " in universe : " + String.valueOf(this.order)));
        }
        for (ReplicationNode node : nodes) {
            if (this.order.contains(node)) {
                throw new IllegalStateException("Node " + String.valueOf(node) + " is already registred : " + String.valueOf(this.order));
            }
            this.order.add(node);
        }
    }

    public TopiaEntityEnum[] getContracts() {
        return this.contracts;
    }

    public String[] getTopiaIds() {
        return this.topiaIds;
    }

    public List<ReplicationNode> getOrder() {
        return this.order;
    }

    public boolean isReplicateAll() {
        return this.replicateAll;
    }

    public ReplicationNode getNode(String propertyName, Class<?> propertyType) {
        Class<?> t;
        TopiaEntityEnum e;
        if (TopiaEntity.class.isAssignableFrom(propertyType) && this.nodes.containsKey(e = this.getContract(t = propertyType))) {
            ReplicationNode dep = this.getNode(e);
            return dep;
        }
        return null;
    }

    public void detectAssociations(TopiaEntityEnum ... filter) throws TopiaException {
        for (TopiaEntityEnum type : this.nodes.keySet()) {
            ReplicationNode node = this.getNode(type);
            EntityOperator<? super TopiaEntity> operator = node.getOperator();
            List associationProperties = operator.getAssociationProperties();
            if (associationProperties.isEmpty()) continue;
            for (String p : associationProperties) {
                ReplicationNode dep = this.getNode(p, operator.getAssociationPropertyType(p));
                if (dep == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("from type - " + type.getContract().getSimpleName() + " [" + p + ":" + String.valueOf(dep) + "]"));
                }
                node.addAssociation(p, dep);
            }
        }
    }

    public void detectDirectDependencies() throws TopiaException {
        for (TopiaEntityEnum type : this.nodes.keySet()) {
            ReplicationNode node = this.getNode(type);
            EntityOperator<? super TopiaEntity> operator = node.getOperator();
            List properties = operator.getProperties();
            if (properties.isEmpty()) continue;
            for (String p : properties) {
                ReplicationNode dep = this.getNode(p, operator.getPropertyType(p));
                if (dep == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("from type - " + type.getContract().getSimpleName() + " [" + p + ":" + String.valueOf(dep) + "]"));
                }
                node.addDependency(p, dep);
            }
        }
    }

    public void detectDependencies() throws TopiaException {
        HashSet<ReplicationNode> toResolved = new HashSet<ReplicationNode>(this.nodes.values());
        HashSet resolved = new HashSet();
        ArrayList levels = new ArrayList();
        while (!toResolved.isEmpty()) {
            HashSet<ReplicationNode> level = new HashSet<ReplicationNode>();
            for (ReplicationNode replicationNode : toResolved) {
                if (!replicationNode.hasDependency()) continue;
                for (ReplicationNode n : replicationNode.getDependencies().values()) {
                    if (resolved.contains(n)) continue;
                    level.add(n);
                }
            }
            HashSet<ReplicationNode> safeLevel = new HashSet<ReplicationNode>();
            if (level.isEmpty()) {
                safeLevel.addAll(toResolved);
            } else {
                for (ReplicationNode n : level) {
                    safeLevel.add(n);
                }
                if (safeLevel.isEmpty()) {
                    throw new IllegalStateException("un cycle dans les dependences a \u00e9t\u00e9 d\u00e9tect\u00e9, l'algorithme necessite plus de donnes... \n niveau courant : " + String.valueOf(level) + "\n resolus : " + String.valueOf(this.getOrder()));
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("level [" + levels.size() + "] resolved : " + String.valueOf(safeLevel)));
            }
            toResolved.removeAll(safeLevel);
            resolved.addAll(safeLevel);
            levels.add(safeLevel);
            level.clear();
        }
        HashSet<ReplicationNode> done = new HashSet<ReplicationNode>();
        for (Set set : levels) {
            this.detectDependenciesOrder(set, done);
        }
    }

    public void detectDependenciesOrder(Set<ReplicationNode> safeLevel, Set<ReplicationNode> doned) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("will detect " + String.valueOf(safeLevel)));
        }
        HashMap<ReplicationNode, HashSet<ReplicationNode>> dico = new HashMap<ReplicationNode, HashSet<ReplicationNode>>();
        for (ReplicationNode replicationNode : safeLevel) {
            HashSet<ReplicationNode> hashSet = new HashSet<ReplicationNode>(replicationNode.getShell());
            hashSet.retainAll(safeLevel);
            if (log.isDebugEnabled()) {
                log.debug((Object)("shell to use for " + String.valueOf(replicationNode) + " : " + String.valueOf(hashSet)));
            }
            dico.put(replicationNode, hashSet);
        }
        ArrayList levels = new ArrayList();
        while (!dico.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("level [" + levels.size() + "] on  " + String.valueOf(safeLevel)));
                for (Map.Entry entry : dico.entrySet()) {
                    log.debug((Object)("node " + String.valueOf(entry.getKey()) + " : " + String.valueOf(entry.getValue())));
                }
            }
            HashSet<ReplicationNode> hashSet = new HashSet<ReplicationNode>();
            for (Map.Entry e : dico.entrySet()) {
                if (!((Set)e.getValue()).isEmpty()) continue;
                hashSet.add((ReplicationNode)e.getKey());
            }
            if (hashSet.isEmpty()) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("level [" + levels.size() + "] cycle detecte : " + String.valueOf(dico.keySet())));
                }
                throw new IllegalStateException("un cycle n'a pas pu etre resoud entre l'ensemble " + String.valueOf(dico.keySet()));
            }
            log.info((Object)("there is some free node(s) to resolve : " + String.valueOf(hashSet)));
            for (Map.Entry e : dico.entrySet()) {
                Set list = (Set)e.getValue();
                list.removeAll(hashSet);
            }
            for (ReplicationNode n : hashSet) {
                dico.remove(n);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("level [" + levels.size() + "] resolved : " + String.valueOf(hashSet)));
            }
            levels.add(hashSet);
            doned.addAll(hashSet);
            if (!dico.isEmpty()) continue;
            break;
        }
        for (Set set : levels) {
            this.addDependency(new ArrayList<ReplicationNode>(set));
        }
        dico.clear();
        levels.clear();
    }

    public void detectObjectsToDettach() {
        HashSet<ReplicationNode> universe = new HashSet<ReplicationNode>();
        for (ReplicationNode node : this.getOrder()) {
            ReplicationNode nodeDst;
            if (node.hasAssociation()) {
                for (Map.Entry<String, ReplicationNode> e : node.getAssociations().entrySet()) {
                    nodeDst = e.getValue();
                    if (universe.contains(nodeDst)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("association to dettach " + e.getKey() + " for " + String.valueOf(node)));
                    }
                    node.addAssociationToDettach(e.getKey());
                }
            }
            if (node.hasDependency()) {
                for (Map.Entry<String, ReplicationNode> e : node.getDependencies().entrySet()) {
                    nodeDst = e.getValue();
                    if (universe.contains(nodeDst)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("dependency to dettach " + e.getKey() + " for " + String.valueOf(node)));
                    }
                    node.addDependencyToDettach(e.getKey());
                }
            }
            universe.add(node);
        }
    }

    public void detectOperations() {
        HashSet<ReplicationNode> universe = new HashSet<ReplicationNode>();
        HashSet<ReplicationLink> links = new HashSet<ReplicationLink>();
        HashSet<ReplicationLink> linksToLoad = new HashSet<ReplicationLink>();
        for (ReplicationNode node : this.order) {
            if (!node.hasAssociation()) continue;
            for (Map.Entry<String, ReplicationNode> entry : node.getAssociations().entrySet()) {
                String name = entry.getKey();
                ReplicationNode target = node.getAssociations().get(name);
                ReplicationLink link = new ReplicationLink(node, target, name, true);
                if (!this.nodes.containsValue(target)) continue;
                links.add(link);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("link to treate : " + String.valueOf(link)));
            }
            List associationProperties = node.getOperator().getAssociationProperties();
            for (String name : associationProperties) {
                Class associationPropertyType = node.getOperator().getAssociationPropertyType(name);
                TopiaEntityEnum contract = this.getContract(associationPropertyType);
                if (contract != null && this.nodes.containsKey(contract)) continue;
                ReplicationLink link = new ReplicationLink(node, null, name, true);
                linksToLoad.add(link);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("link to load before replication : " + String.valueOf(link)));
            }
        }
        for (ReplicationNode node : this.order) {
            log.debug((Object)("------------------------------- for node " + String.valueOf(node)));
            if (node.hasAssociationsToDettach()) {
                Set<String> names = node.getAssociationsToDettach();
                for (String name : names) {
                    this.addPreOperation(node, node, DettachAssociation.class, name);
                }
            }
            HashSet<ReplicationLink> tmpLinks = new HashSet<ReplicationLink>();
            for (ReplicationLink link : linksToLoad) {
                if (!node.equals(link.getSource())) continue;
                tmpLinks.add(link);
            }
            if (!tmpLinks.isEmpty()) {
                for (ReplicationLink link : tmpLinks) {
                    this.addPreOperation(node, link.getSource(), LoadLink.class, link);
                }
                linksToLoad.removeAll(links);
                tmpLinks.clear();
            }
            this.addDuplicateOperation(node, node, Duplicate.class, new Object[0]);
            universe.add(node);
            for (ReplicationLink link : links) {
                if (!link.canReattach(universe, node)) continue;
                tmpLinks.add(link);
            }
            if (tmpLinks.isEmpty()) continue;
            for (ReplicationLink link : tmpLinks) {
                this.addPostOperation(node, link.getTarget(), AttachLink.class, link);
            }
            links.removeAll(tmpLinks);
        }
    }

    public void adjustOperations(TopiaEntityIdsMap data) {
        for (TopiaEntityEnum e : this.getContracts()) {
            List ids = (List)data.get((Object)e.getContract());
            ReplicationNode node = this.getNode(e);
            if (node == null) continue;
            ArrayList<ReplicationOperationDef> realOperations = new ArrayList<ReplicationOperationDef>();
            if (CollectionUtils.isEmpty((Collection)ids)) {
                ReplicationOperationDef[] operations;
                if (log.isInfoEnabled()) {
                    log.info((Object)("skip operations on node " + String.valueOf(node) + " (no data associated)"));
                }
                for (ReplicationOperationDef op : operations = node.getOperations()) {
                    if (!node.equals(op.getNode())) {
                        realOperations.add(op);
                        if (!log.isInfoEnabled()) continue;
                        log.info((Object)("  keep " + String.valueOf(op)));
                        continue;
                    }
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)("  skip " + String.valueOf(op)));
                }
                node.setOperations(realOperations);
            }
            node.sortOperations();
        }
    }

    public void detectShell() {
        for (ReplicationNode n : this.nodes.values()) {
            HashSet<ReplicationNode> shell = new HashSet<ReplicationNode>();
            this.getShell(n, shell);
            shell.remove(n);
            n.setShell(shell);
        }
    }

    protected void getShell(ReplicationNode node, Set<ReplicationNode> explored) {
        if (!explored.contains(node)) {
            explored.add(node);
        }
        if (node.hasAssociation()) {
            for (ReplicationNode n : node.getAssociations().values()) {
                if (explored.contains(n)) continue;
                this.getShell(n, explored);
            }
        }
        if (node.hasDependency()) {
            for (ReplicationNode n : node.getDependencies().values()) {
                if (explored.contains(n)) continue;
                this.getShell(n, explored);
            }
        }
    }

    protected void addPreOperation(ReplicationNode ownerNode, ReplicationNode node, Class<? extends TopiaReplicationOperation> operationClass, Object ... params) {
        this.addOperation(ownerNode, node, ReplicationOperationPhase.before, operationClass, params);
    }

    protected void addDuplicateOperation(ReplicationNode ownerNode, ReplicationNode node, Class<? extends TopiaReplicationOperation> operationClass, Object ... params) {
        this.addOperation(ownerNode, node, ReplicationOperationPhase.duplicate, operationClass, params);
    }

    protected void addPostOperation(ReplicationNode ownerNode, ReplicationNode node, Class<? extends TopiaReplicationOperation> operationClass, Object ... params) {
        this.addOperation(ownerNode, node, ReplicationOperationPhase.after, operationClass, params);
    }

    protected void addOperation(ReplicationNode ownerNode, ReplicationNode node, ReplicationOperationPhase phase, Class<? extends TopiaReplicationOperation> operationClass, Object ... params) {
        ReplicationOperationDef op = new ReplicationOperationDef(phase, operationClass, node, params);
        ownerNode.addOperation(op);
    }
}

