/*
 * #%L
 * ToPIA :: Service Migration
 * 
 * $Id: ExceptionAttributeUndefined.java 1894 2010-04-15 15:44:51Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.3.3/topia-service-migration/src/main/java/org/nuiton/topia/migration/common/ExceptionAttributeUndefined.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia.migration.common;

/**
 * ExceptionAttributeUndefined.java
 *
 * Lancee si le developpeur tente d'acceder a des attribut non existant.
 *  
 * @author Chatellier Eric
 * @author Chevallereau Benjamin
 * @author Eon Sébastien
 * @author Trève Vincent
 * @version $Revision: 1894 $
 *
 * Last update : $Date: 2010-04-15 17:44:51 +0200 (jeu., 15 avril 2010) $
 */
public class ExceptionAttributeUndefined extends Exception {

	/**
	 * Version UID
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * Constructeur par defaut
	 */
	public ExceptionAttributeUndefined() {
	}

	/**
	 * Constructeur avec message
	 * @param message
	 */
	public ExceptionAttributeUndefined(String message) {
		super(message);
	}

	/**
	 * Constructeur avec exception
	 * @param cause
	 */
	public ExceptionAttributeUndefined(Throwable cause) {
		super(cause);
	}

	/**
	 * Constructeur avec message et exception
	 * @param message
	 * @param cause
	 */
	public ExceptionAttributeUndefined(String message, Throwable cause) {
		super(message, cause);
	}
}
