package org.nuiton.topia.migration;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;


public class MigrationServiceDAOHelper {



    public enum MigrationServiceEntityEnum implements TopiaEntityEnum {

        TMSVersion(TMSVersion.class);
        /**
         * the contract of the entity
         */
        protected Class<? extends TopiaEntity> contract;
        /**
         * the fully qualified name of the implementation of the entity
         */
        protected String implementationFQN;
        /**
         * the implementation class of the entity (will be lazy computed at runtime)
         */
        protected Class<? extends TopiaEntity> implementation;
        /**
         * MigrationServiceEntityEnum :
             * @param contract 
     */

         MigrationServiceEntityEnum(Class<? extends TopiaEntity > contract)     {
        this.contract = contract;
        this.implementationFQN = contract.getName()+"Impl";
        }

        /**
         * getContract :
             * @return Class<? extends TopiaEntity> 
     */

        public Class<? extends TopiaEntity> getContract()     {
        return contract;
        }

        /**
         * getImplementationFQN :
             * @return String 
     */

        public String getImplementationFQN()     {
        return implementationFQN;
        }

        /**
         * setImplementationFQN :
             * @param implementationFQN 
     */

        public void setImplementationFQN(String implementationFQN)     {
        this.implementationFQN = implementationFQN;
        this.implementation = null;
        }

        /**
         * accept :
             * @param klass 
         * @return boolean 
     */

        public boolean accept(Class<? extends TopiaEntity> klass)     {
         return MigrationServiceDAOHelper.getContractClass(klass) == contract;
         }

        /**
         * getImplementation :
             * @return Class<? extends TopiaEntity> 
     */

        public Class<? extends TopiaEntity> getImplementation()     {
         if (implementation == null) {
            try {
                    implementation = (Class<? extends TopiaEntity>) Class.forName(implementationFQN);
                } catch (ClassNotFoundException e) {
                    throw new RuntimeException("could not find class " + implementationFQN);
                }
         }
         return implementation;
         }

        /**
         * valueOf :
             * @param entity 
         * @return MigrationServiceEntityEnum 
     */

        public static MigrationServiceEntityEnum valueOf(TopiaEntity entity)     {
         return valueOf(entity.getClass());
         }

        /**
         * valueOf :
             * @param klass 
         * @return MigrationServiceEntityEnum 
     */

        public static MigrationServiceEntityEnum valueOf(Class<?> klass)     {
         if (klass.isInterface()) {
            return MigrationServiceEntityEnum.valueOf(klass.getSimpleName());
         }
         for (MigrationServiceEntityEnum entityEnum : MigrationServiceEntityEnum.values()) {
             if (entityEnum.getContract().isAssignableFrom(klass)) {
                 //todo check it works for inheritance
                 return entityEnum;
             }
         }
         throw new IllegalArgumentException("no entity defined for the class " + klass + " in : " + Arrays.toString(MigrationServiceEntityEnum.values()));
         }


    } //MigrationServiceEntityEnum
        /**
         * MigrationServiceDAOHelper :
         */

        protected MigrationServiceDAOHelper()     {     }

        /**
         * getModelVersion :
             * @return String 
     */

        public static String getModelVersion()     {
        return "1";
        }

        /**
         * getModelName :
             * @return String 
     */

        public static String getModelName()     {
        return "MigrationService";
        }

        /**
         * getTMSVersionDAO :
             * @param context 
         * @return TMSVersionDAO 
         * @throws TopiaException
     */

        public static TMSVersionDAO getTMSVersionDAO(TopiaContext context) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        TMSVersionDAO result = (TMSVersionDAO) ci.getDAO(TMSVersion.class);
        return result;
        }

        /**
         * getDAO :
             * @param context 
         * @param klass 
         * @return <T extends TopiaEntity, D extends TopiaDAO<? super T>> D 
         * @throws TopiaException
     */

        public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, Class<T> klass) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        MigrationServiceEntityEnum constant = MigrationServiceEntityEnum.valueOf(klass);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
        }

        /**
         * getDAO :
             * @param context 
         * @param entity 
         * @return <T extends TopiaEntity, D extends TopiaDAO<? super T>> D 
         * @throws TopiaException
     */

        public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, T entity) throws TopiaException     {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        MigrationServiceEntityEnum constant = MigrationServiceEntityEnum.valueOf(entity);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
        }

        /**
         * getContractClass :
             * @param klass 
         * @return <T extends TopiaEntity> Class<T> 
     */

        public static <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass)     {
        MigrationServiceEntityEnum constant = MigrationServiceEntityEnum.valueOf(klass);
        return (Class<T>) constant.getContract();
        }

        /**
         * getImplementationClass :
             * @param klass 
         * @return <T extends TopiaEntity> Class<T> 
     */

        public static <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass)     {
        MigrationServiceEntityEnum constant = MigrationServiceEntityEnum.valueOf(klass);
        return (Class<T>) constant.getImplementation();
        }

        /**
         * getContractClasses :
             * @return Class<? extends TopiaEntity>[] 
     */

        public static Class<? extends TopiaEntity>[] getContractClasses()     {
        MigrationServiceEntityEnum[] values = MigrationServiceEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getContract();
        }
        return result;
        }

        /**
         * getImplementationClasses :
             * @return Class<? extends TopiaEntity>[] 
     */

        public static Class<? extends TopiaEntity>[] getImplementationClasses()     {
        MigrationServiceEntityEnum[] values = MigrationServiceEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getImplementation();
        }
        return result;
        }

        /**
         * getImplementationClassesAsString :
             * @return String 
     */

        public static String getImplementationClassesAsString()     {
        StringBuilder buffer = new StringBuilder();
        for (Class<? extends TopiaEntity> aClass : getImplementationClasses()) {
            buffer.append(',').append(aClass.getName());
        }
        return buffer.substring(1);
        }

        /**
         * getContracts :
             * @return MigrationServiceEntityEnum[] 
     */

        public static MigrationServiceEntityEnum[] getContracts()     {
        return MigrationServiceEntityEnum.values();
        }


    } //MigrationServiceDAOHelper
