/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.security.Permission;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.metadata.ClassMetadata;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.event.TopiaEntityListener;
import org.nuiton.topia.event.TopiaEntityVetoable;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityContextable;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.pager.TopiaPagerBean;
import org.nuiton.util.PagerBean;
import org.nuiton.util.PagerBeanUtil;

public class TopiaDAOImpl<E extends TopiaEntity>
implements TopiaDAO<E> {
    private static Log log = LogFactory.getLog(TopiaDAOImpl.class);
    protected Class<E> entityClass;
    protected TopiaContextImplementor context;
    private int batchSize = 1000;

    @Override
    public TopiaEntityEnum getTopiaEntityEnum() {
        throw new UnsupportedOperationException("This method must be overided in generated DAO");
    }

    @Override
    public Class<E> getEntityClass() {
        throw new UnsupportedOperationException("This method must be overided in generated DAO");
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    private E query(Criterion criterion) throws TopiaException {
        try {
            int sizeAfter;
            Criteria criteria = this.createCriteria(FlushMode.AUTO);
            criteria.add(criterion);
            criteria.setMaxResults(1);
            List result = criteria.list();
            int sizeBefore = result != null ? result.size() : 0;
            result = this.getContext().getFiresSupport().fireEntitiesLoad(this.context, result);
            int n = sizeAfter = result != null ? result.size() : 0;
            if (sizeAfter < sizeBefore && log.isDebugEnabled()) {
                log.debug((Object)(sizeBefore - sizeAfter + " element(s) removed. Filter entity: " + this.entityClass.getName() + " - criterion: " + criterion));
            }
            if (result != null && result.size() > 0) {
                TopiaEntity elem = (TopiaEntity)result.get(0);
                return (E)elem;
            }
            return null;
        }
        catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
    }

    private Criteria createCriteria(FlushMode mode) throws TopiaException {
        Criteria criteria = this.getSession().createCriteria(this.entityClass);
        criteria.setFlushMode(mode);
        return criteria;
    }

    @Override
    public Iterator<E> iterator() {
        FindAllIterator iterator = new FindAllIterator(this, this.getEntityClass(), this.batchSize, "FROM " + this.getTopiaEntityEnum().getImplementationFQN() + " ORDER BY id", new Object[0]);
        return iterator;
    }

    protected Serializable getId(E e) throws TopiaException {
        ClassMetadata meta = this.getClassMetadata();
        String idPropName = meta.getIdentifierPropertyName();
        try {
            Serializable result = (Serializable)PropertyUtils.getSimpleProperty(e, (String)idPropName);
            return result;
        }
        catch (Exception eee) {
            throw new TopiaException("Impossible de r\u00e9cuperer l'identifiant " + idPropName + " de l'entite: " + e);
        }
    }

    protected Serializable getId(Map map) throws TopiaException {
        try {
            ClassMetadata meta = this.getClassMetadata();
            String idPropName = meta.getIdentifierPropertyName();
            Serializable id = (Serializable)map.get(idPropName);
            return id;
        }
        catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
    }

    @Override
    public void init(TopiaContextImplementor context, Class<E> entityClass) throws TopiaException {
        log.debug((Object)("init dao for " + entityClass.getName()));
        this.context = context;
        this.entityClass = entityClass;
    }

    @Override
    public TopiaContextImplementor getContext() {
        return this.context;
    }

    @Override
    public String createSimpleQuery(String alias) {
        String hql = "FROM " + this.getTopiaEntityEnum().getImplementationFQN();
        if (StringUtils.isNotBlank((CharSequence)alias)) {
            hql = hql + " " + alias;
        }
        return hql;
    }

    @Override
    public E newInstance() throws TopiaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("entityClass = " + this.entityClass));
        }
        Class<? extends TopiaEntity> implementation = this.getTopiaEntityEnum().getImplementation();
        try {
            TopiaEntity result = implementation.newInstance();
            return (E)result;
        }
        catch (Exception e) {
            throw new TopiaException("Impossible de trouver ou d'instancier la classe " + implementation);
        }
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E e) throws TopiaException {
        throw new UnsupportedOperationException("This method must be overided in generated DAO");
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E e) throws TopiaException {
        throw new UnsupportedOperationException("This method must be overided in generated DAO");
    }

    @Override
    public List<Permission> getRequestPermission(String topiaId, int actions) throws TopiaException {
        return null;
    }

    @Override
    public void addTopiaEntityListener(TopiaEntityListener listener) {
        this.getContext().addTopiaEntityListener(this.entityClass, listener);
    }

    @Override
    public void addTopiaEntityVetoable(TopiaEntityVetoable vetoable) {
        this.getContext().addTopiaEntityVetoable(this.entityClass, vetoable);
    }

    @Override
    public void removeTopiaEntityListener(TopiaEntityListener listener) {
        this.getContext().removeTopiaEntityListener(this.entityClass, listener);
    }

    @Override
    public void removeTopiaEntityVetoable(TopiaEntityVetoable vetoable) {
        this.getContext().removeTopiaEntityVetoable(this.entityClass, vetoable);
    }

    @Override
    public E create(E entity) throws TopiaException {
        try {
            if (StringUtils.isBlank((CharSequence)entity.getTopiaId())) {
                String topiaId = this.getContext().getTopiaIdFactory().newTopiaId(this.entityClass, (TopiaEntity)entity);
                entity.setTopiaId(topiaId);
            }
            if (entity instanceof TopiaEntityContextable) {
                TopiaEntityContextable contextable = (TopiaEntityContextable)entity;
                contextable.setTopiaContext(this.getContext());
            }
            this.getSession().save(entity);
            this.getContext().getFiresSupport().warnOnCreateEntity((TopiaEntity)entity);
            return entity;
        }
        catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
    }

    @Override
    public E create(Object ... propertyNamesAndValues) throws TopiaException {
        int propertiesLength = propertyNamesAndValues.length;
        Preconditions.checkArgument((propertiesLength % 2 == 0 ? 1 : 0) != 0, (Object)("Wrong number of argument " + propertiesLength + ", you must have even number."));
        HashMap<String, Object> map = new HashMap<String, Object>();
        int i = 0;
        while (i < propertiesLength) {
            Object propertyName = propertyNamesAndValues[i++];
            Object value = propertyNamesAndValues[i++];
            Preconditions.checkArgument((boolean)(propertyName instanceof String), (Object)("Argument at position [" + (i - 1) + "] " + "shoud be a property name (says a String) but was " + propertyName));
            map.put((String)propertyName, value);
        }
        E result = this.create((Map<String, Object>)map);
        return result;
    }

    @Override
    public E create(Map<String, Object> properties) throws TopiaException {
        E result = this.newInstance();
        try {
            for (Map.Entry<String, Object> e : properties.entrySet()) {
                String propertyName = e.getKey();
                Object value = e.getValue();
                PropertyUtils.setProperty(result, (String)propertyName, (Object)value);
            }
        }
        catch (IllegalAccessException eee) {
            throw new IllegalArgumentException("Can't put properties on new Object", eee);
        }
        catch (InvocationTargetException eee) {
            throw new IllegalArgumentException("Can't put properties on new Object", eee);
        }
        catch (NoSuchMethodException eee) {
            throw new IllegalArgumentException("Can't put properties on new Object", eee);
        }
        this.create(result);
        return result;
    }

    @Override
    public E update(E e) throws TopiaException {
        try {
            this.getSession().saveOrUpdate(e);
            this.getContext().getFiresSupport().warnOnUpdateEntity((TopiaEntity)e);
            return e;
        }
        catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
    }

    @Override
    public void delete(E e) throws TopiaException {
        try {
            this.getSession().delete(e);
            e.notifyDeleted();
            this.getContext().getFiresSupport().warnOnDeleteEntity((TopiaEntity)e);
        }
        catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
    }

    @Override
    public void deleteAll(Iterable<E> entities) throws TopiaException {
        for (TopiaEntity entity : entities) {
            this.delete(entity);
        }
    }

    @Override
    public E findByTopiaId(String id) throws TopiaException {
        E result = this.query(Restrictions.idEq((Object)id));
        return result;
    }

    @Override
    public E findByProperty(String propertyName, Object value) throws TopiaException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(propertyName, value);
        E result = this.findByProperties(properties);
        return result;
    }

    @Override
    public E findByProperties(String propertyName, Object value, Object ... propertyNamesAndValues) throws TopiaException {
        Map<String, Object> properties = this.convertPropertiesArrayToMap(propertyName, value, propertyNamesAndValues);
        E result = this.findByProperties(properties);
        return result;
    }

    @Override
    public E findByProperties(Map<String, Object> properties) throws TopiaException {
        E result = this.query(Restrictions.allEq(properties));
        return result;
    }

    @Override
    public List<E> findAll() throws TopiaException {
        try {
            Criteria criteria = this.createCriteria(FlushMode.AUTO);
            List result = criteria.list();
            result = this.getContext().getFiresSupport().fireEntitiesLoad(this.context, result);
            return result;
        }
        catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
    }

    @Override
    public List<String> findAllIds() throws TopiaException {
        List<String> find = this.context.findAll("select src.topiaId from " + this.getEntityClass().getName() + " src", new Object[0]);
        return find;
    }

    @Override
    public List<E> findAllByProperty(String propertyName, Object value) throws TopiaException {
        Map<String, Object> properties = this.convertPropertiesArrayToMap(propertyName, value, new Object[0]);
        List<E> result = this.findAllByProperties(properties);
        return result;
    }

    @Override
    public List<E> findAllByProperties(String propertyName, Object value, Object ... propertyNamesAndValues) throws TopiaException {
        Map<String, Object> properties = this.convertPropertiesArrayToMap(propertyName, value, propertyNamesAndValues);
        List<E> result = this.findAllByProperties(properties);
        return result;
    }

    @Override
    public List<E> findAllByProperties(Map<String, Object> properties) throws TopiaException {
        List<E> result = this.queryAll(Restrictions.allEq(properties));
        return result;
    }

    private List<E> queryAll(Criterion criterion) throws TopiaException {
        try {
            Criteria criteria = this.createCriteria(FlushMode.AUTO);
            criteria.add(criterion);
            List result = criteria.list();
            result = this.getContext().getFiresSupport().fireEntitiesLoad(this.context, result);
            return result;
        }
        catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
    }

    @Override
    public List<E> findAllWithOrder(String ... propertyNames) throws TopiaException {
        try {
            Criteria criteria = this.createCriteria(FlushMode.AUTO);
            for (String propertyName : propertyNames) {
                criteria.addOrder(Order.asc((String)propertyName));
            }
            List result = criteria.list();
            result = this.getContext().getFiresSupport().fireEntitiesLoad(this.context, result);
            return result;
        }
        catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
    }

    @Override
    public E findContains(String propertyName, Object value) throws TopiaException {
        TopiaEntity find = (TopiaEntity)this.context.findUnique("from " + this.getEntityClass().getName() + " WHERE :property in elements(" + propertyName + ")", "property", value);
        return (E)find;
    }

    @Override
    public List<E> findAllContains(String propertyName, Object value) throws TopiaException {
        List find = this.context.findAll("from " + this.getEntityClass().getName() + " WHERE :property in elements(" + propertyName + ")", "property", value);
        return find;
    }

    @Override
    public boolean existByTopiaId(String id) throws TopiaException {
        boolean result = this.existByProperties("topiaId", id, new Object[0]);
        return result;
    }

    @Override
    public boolean existByProperties(String propertyName, Object propertyValue, Object ... propertyNamesAndValues) throws TopiaException {
        Map<String, Object> properties = this.convertPropertiesArrayToMap(propertyName, propertyValue, propertyNamesAndValues);
        try {
            Criteria criteria = this.createCriteria(FlushMode.AUTO);
            criteria.add(Restrictions.allEq(properties));
            criteria.setProjection(Projections.rowCount());
            Number count = (Number)criteria.uniqueResult();
            boolean result = count.intValue() > 0;
            return result;
        }
        catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
    }

    @Override
    public long count() throws TopiaException {
        try {
            Criteria criteria = this.createCriteria(FlushMode.AUTO);
            criteria.setProjection(Projections.rowCount());
            long result = ((Number)criteria.uniqueResult()).longValue();
            return result;
        }
        catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
    }

    private Map<String, Object> convertPropertiesArrayToMap(String propertyName, Object propertyValue, Object ... others) throws IllegalArgumentException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(propertyName, propertyValue);
        Object name = null;
        int i = 0;
        while (i < others.length) {
            try {
                name = others[i++];
                propertyValue = others[i++];
                properties.put((String)name, propertyValue);
            }
            catch (ClassCastException eee) {
                throw new IllegalArgumentException("Les noms des propri\u00e9t\u00e9s doivent \u00eatre des chaines et non pas " + propertyName.getClass().getName(), eee);
            }
            catch (ArrayIndexOutOfBoundsException eee) {
                throw new IllegalArgumentException("Le nombre d'argument n'est pas un nombre pair: " + (others.length + 2) + " La derni\u00e8re propri\u00e9t\u00e9 \u00e9tait: " + name, eee);
            }
        }
        return properties;
    }

    @Override
    public E findByPrimaryKey(Map<String, Object> keys) throws TopiaException {
        try {
            ClassMetadata meta = this.getClassMetadata();
            if (meta.hasNaturalIdentifier()) {
                E result = this.findByProperties(keys);
                return result;
            }
        }
        catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
        throw new TopiaException("La classe " + this.entityClass.getName() + " n'a pas de cle primaire naturelle");
    }

    @Override
    public E findByPrimaryKey(Object ... k) throws TopiaException {
        try {
            ClassMetadata meta = this.getClassMetadata();
            if (meta.hasNaturalIdentifier()) {
                int[] ikeys = meta.getNaturalIdentifierProperties();
                String[] pnames = meta.getPropertyNames();
                HashMap<String, Object> keys = new HashMap<String, Object>();
                for (int ikey : ikeys) {
                    keys.put(pnames[ikey], k[ikey]);
                }
                E result = this.findByProperties(keys);
                return result;
            }
        }
        catch (HibernateException eee) {
            throw new TopiaException(eee);
        }
        throw new TopiaException("La classe " + this.entityClass.getName() + " n'a pas de cle primaire naturelle");
    }

    @Override
    public boolean existsByQuery(String hql, Object ... propertyNamesAndValues) throws TopiaException {
        long count = this.countByQuery(hql, propertyNamesAndValues);
        return count > 0L;
    }

    @Override
    public long countByQuery(String hql, Object ... propertyNamesAndValues) throws TopiaException {
        Preconditions.checkNotNull((Object)StringUtils.isNotBlank((CharSequence)hql));
        Preconditions.checkArgument((boolean)hql.toUpperCase().trim().startsWith("SELECT COUNT("));
        Long result = this.findByQuery(Long.class, hql, propertyNamesAndValues);
        return result;
    }

    @Override
    public E findByQuery(String hql, Object ... propertyNamesAndValues) throws TopiaException {
        TopiaEntity result = (TopiaEntity)this.findByQuery(this.getEntityClass(), hql, propertyNamesAndValues);
        return (E)result;
    }

    @Override
    public <R> R findByQuery(Class<R> type, String hql, Object ... params) throws TopiaException {
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull((Object)hql);
        Object unique = this.getContext().findUnique(hql, params);
        Preconditions.checkState((unique == null || type.isAssignableFrom(unique.getClass()) ? 1 : 0) != 0);
        return (R)unique;
    }

    @Override
    public List<E> findAllByQuery(String hql, Object ... propertyNamesAndValues) throws TopiaException {
        List<E> result = this.findAllByQuery(this.getEntityClass(), hql, propertyNamesAndValues);
        return result;
    }

    @Override
    public <R> List<R> findAllByQuery(Class<R> type, String hql, Object ... propertyNamesAndValues) throws TopiaException {
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull((Object)hql);
        List result = this.getContext().findAll(hql, propertyNamesAndValues);
        return result;
    }

    @Override
    public Iterable<E> findAllLazyByQuery(String hql, Object ... propertyNamesAndValues) throws TopiaException {
        Iterable<E> result = this.findAllLazyByQuery(this.batchSize, hql, propertyNamesAndValues);
        return result;
    }

    @Override
    public <R> Iterable<R> findAllLazyByQuery(Class<R> type, String hql, Object ... propertyNamesAndValues) throws TopiaException {
        Iterable<R> result = this.findAllLazyByQuery(type, this.batchSize, hql, propertyNamesAndValues);
        return result;
    }

    @Override
    public Iterable<E> findAllLazyByQuery(int batchSize, String hql, Object ... propertyNamesAndValues) throws TopiaException {
        return this.findAllLazyByQuery(this.getEntityClass(), batchSize, hql, propertyNamesAndValues);
    }

    @Override
    public <R> Iterable<R> findAllLazyByQuery(Class<R> type, int batchSize, String hql, Object ... propertyNamesAndValues) throws TopiaException {
        final FindAllIterator iterator = new FindAllIterator(this, type, batchSize, hql, propertyNamesAndValues);
        Iterable result = new Iterable<R>(){

            @Override
            public Iterator<R> iterator() {
                return iterator;
            }
        };
        return result;
    }

    @Override
    public <R> List<R> findAllByQueryWithBound(Class<R> type, String hql, int startIndex, int endIndex, Object ... propertyNamesAndValues) throws TopiaException {
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull((Object)hql);
        List result = this.getContext().find(hql, startIndex, endIndex, propertyNamesAndValues);
        return result;
    }

    @Override
    public List<E> findAllByQueryWithBound(String hql, int startIndex, int endIndex, Object ... propertyNamesAndValues) throws TopiaException {
        List<E> result = this.findAllByQueryWithBound(this.getEntityClass(), hql, startIndex, endIndex, propertyNamesAndValues);
        return result;
    }

    @Override
    public <R> List<R> findAllByQueryAndPager(Class<R> type, String hql, TopiaPagerBean pager, Object ... propertyNamesAndValues) throws TopiaException {
        Preconditions.checkNotNull((Object)((Object)pager));
        Preconditions.checkNotNull((Object)hql);
        if (StringUtils.isNotBlank((CharSequence)pager.getSortColumn())) {
            hql = hql + " ORDER BY " + pager.getSortColumn();
            if (!pager.isSortAscendant()) {
                hql = hql + " DESC";
            }
        }
        List<R> result = this.findAllByQueryWithBound(type, hql, (int)pager.getRecordStartIndex(), (int)pager.getRecordEndIndex() - 1, propertyNamesAndValues);
        return result;
    }

    @Override
    public List<E> findAllByQueryAndPager(String hql, TopiaPagerBean pager, Object ... propertyNamesAndValues) throws TopiaException {
        List<E> result = this.findAllByQueryAndPager(this.getEntityClass(), hql, pager, propertyNamesAndValues);
        return result;
    }

    @Override
    public void computeAndAddRecordsToPager(String hql, TopiaPagerBean pager, Object ... propertyNamesAndValues) throws TopiaException {
        long records = this.countByQuery(hql, propertyNamesAndValues);
        pager.setRecords(records);
        PagerBeanUtil.computeRecordIndexesAndPagesNumber((PagerBean)pager);
    }

    protected Session getSession() throws TopiaException {
        Session result = this.getContext().getHibernate();
        return result;
    }

    protected ClassMetadata getClassMetadata() throws TopiaException {
        ClassMetadata meta = this.getContext().getHibernateFactory().getClassMetadata(this.entityClass);
        if (meta == null) {
            meta = this.getContext().getHibernateFactory().getClassMetadata(this.getTopiaEntityEnum().getImplementationFQN());
        }
        return meta;
    }

    public static class FindAllIterator<E extends TopiaEntity, R>
    implements Iterator<R> {
        protected Iterator<R> data;
        protected final TopiaDAO<E> dao;
        protected final Class<R> type;
        protected final String hql;
        protected final Object[] params;
        protected TopiaPagerBean pager;

        public FindAllIterator(TopiaDAO<E> dao, Class<R> type, int batchSize, String hql, Object ... params) {
            this.dao = dao;
            this.type = type;
            this.hql = hql;
            this.params = params;
            String hql2 = hql.toLowerCase();
            int i = hql2.indexOf("order by");
            if (i == -1) {
                throw new IllegalStateException("must have a *order by* in hql, but did not find it in " + hql);
            }
            long count2 = dao.countByQuery("SELECT COUNT(*) " + hql.substring(0, i), params);
            this.pager = new TopiaPagerBean();
            this.pager.setRecords(count2);
            this.pager.setPageSize(batchSize);
            PagerBeanUtil.computeRecordIndexesAndPagesNumber((PagerBean)this.pager);
            this.data = Iterators.emptyIterator();
        }

        @Override
        public boolean hasNext() {
            boolean result = this.data.hasNext() || (long)this.pager.getPageIndex() < this.pager.getPagesNumber();
            return result;
        }

        @Override
        public R next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.data.hasNext()) {
                this.pager.setPageIndex(this.pager.getPageIndex() + 1);
                PagerBeanUtil.computeRecordIndexesAndPagesNumber((PagerBean)this.pager);
                this.data = this.dao.findAllByQueryAndPager(this.type, this.hql, this.pager, this.params).iterator();
            }
            R next = this.data.next();
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator does not support remove operation.");
        }
    }
}

