/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.csv;

import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.csv.Common;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.csv.ValueParser;
import org.nuiton.csv.ValueParserFormatter;
import org.nuiton.decorator.Decorator;
import org.nuiton.topia.TopiaRuntimeException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.StringUtil;

public class TopiaCsvCommons
extends Common {
    public static final ValueParserFormatter<Date> DAY_TIME_SECOND_WITH_TIMESTAMP = new Common.DateValue("dd/MM/yyyy HH:mm:ss"){

        public Date parse(String value) throws ParseException {
            Date parse = super.parse(value);
            if (parse != null) {
                parse = new Timestamp(parse.getTime());
            }
            return parse;
        }
    };
    public static final ValueParserFormatter<Date> DAY_TIME_SECOND_MILI_WITH_TIMESTAMP = new Common.DateValue("dd/MM/yyyy HH:mm:ss.SSSS"){

        public Date parse(String value) throws ParseException {
            Date parse = super.parse(value);
            if (parse != null) {
                parse = new Timestamp(parse.getTime());
            }
            return parse;
        }
    };
    public static final AssociationValueParser ASSOCIATION_VALUE_PARSER = new AssociationValueParser();

    protected TopiaCsvCommons() {
    }

    public static <E extends TopiaEntity> ForeignKeyValue<E> newForeignKeyValue(Class<E> type, String propertyName, Map<String, E> universe) {
        return new ForeignKeyValue<E>(type, propertyName, universe);
    }

    public static <E extends TopiaEntity> ForeignKeyValueForAssociation<E> newForeignKeyValueAssociation(Class<E> type, String propertyName, Map<String, E> universe) {
        return new ForeignKeyValueForAssociation<E>(type, propertyName, universe);
    }

    public static <E extends TopiaEntity> ValueFormatter<Collection<E>> newAssociationValueFormatter() {
        return new AssociationValueParserFormatter(null, null);
    }

    public static <E> ForeignKeyDecoratedValue<E> newForeignKeyDecoratedValue(Decorator<E> decorator) {
        return new ForeignKeyDecoratedValue<E>(decorator);
    }

    public static class ForeignKeyValue<E extends TopiaEntity>
    implements ValueParserFormatter<E> {
        protected final String propertyName;
        protected final Class<E> entityType;
        protected final Map<String, E> universe;

        public ForeignKeyValue(Class<E> entityType, String propertyName, Map<String, E> universe) {
            this.entityType = entityType;
            this.propertyName = propertyName;
            this.universe = universe;
        }

        public E parse(String value) throws ParseException {
            TopiaEntity result = null;
            if (StringUtils.isNotBlank((CharSequence)value) && (result = (TopiaEntity)this.universe.get(value)) == null) {
                throw new TopiaRuntimeException("Could not find entity of type " + this.entityType.getSimpleName() + " with '" + this.propertyName + "' = " + value);
            }
            return (E)result;
        }

        public String format(E e) {
            String value = "";
            if (e != null) {
                value = e.getTopiaId();
            }
            return value;
        }
    }

    public static class ForeignKeyValueForAssociation<E extends TopiaEntity>
    implements ValueParser<Collection<E>> {
        protected final String propertyName;
        protected final Class<E> entityType;
        protected final Map<String, E> universe;

        public ForeignKeyValueForAssociation(Class<E> entityType, String propertyName, Map<String, E> universe) {
            this.entityType = entityType;
            this.propertyName = propertyName;
            this.universe = universe;
        }

        public Collection<E> parse(String value) throws ParseException {
            TopiaEntity result = null;
            if (StringUtils.isNotBlank((CharSequence)value) && (result = (TopiaEntity)this.universe.get(value)) == null) {
                throw new TopiaRuntimeException("Could not find entity with '" + this.propertyName + "' = " + value);
            }
            return Arrays.asList(result);
        }
    }

    public static class AssociationValueParserFormatter<E extends TopiaEntity>
    implements ValueParserFormatter<Collection<E>> {
        protected final Class<E> entityType;
        protected final Map<String, E> universe;

        public AssociationValueParserFormatter(Class<E> entityType, Map<String, E> universe) {
            this.entityType = entityType;
            this.universe = universe;
        }

        public Collection<E> parse(String value) throws ParseException {
            ArrayList result = Lists.newArrayList();
            if (StringUtils.isNotBlank((CharSequence)value)) {
                String[] ids;
                for (String id : ids = value.split("\\|")) {
                    TopiaEntity association = (TopiaEntity)this.universe.get(id);
                    association.setTopiaId(id);
                    result.add(association);
                }
            }
            return result;
        }

        public String format(Collection<E> e) {
            String value;
            if (CollectionUtils.isEmpty(e)) {
                value = "";
            } else {
                ArrayList ids = Lists.newArrayList();
                for (TopiaEntity e1 : e) {
                    ids.add(e1.getTopiaId());
                }
                value = StringUtil.join((Iterable)ids, (String)"|", (boolean)true);
            }
            return value;
        }
    }

    public static class ForeignKeyDecoratedValue<E>
    implements ValueFormatter<E> {
        protected final Decorator<E> decorator;

        public ForeignKeyDecoratedValue(Decorator<E> decorator) {
            this.decorator = decorator;
        }

        public String format(E e) {
            String value = "";
            if (e != null) {
                value = this.decorator.toString(e);
            }
            return value;
        }
    }

    public static class AssociationValueParser
    implements ValueParser<String[]> {
        public String[] parse(String value) throws ParseException {
            String[] ids = value.split("\\|");
            return ids;
        }
    }
}

