/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.fife.ui.rsyntaxtextarea.MarkOccurrencesHighlightPainter;
import org.fife.ui.rtextarea.RTextArea;

public class RSyntaxTextAreaHighlighter
extends BasicTextUI.BasicHighlighter {
    private RTextArea textArea;
    private List markedOccurrences = new ArrayList();

    Object addMarkedOccurrenceHighlight(int n, int n2, MarkOccurrencesHighlightPainter markOccurrencesHighlightPainter) throws BadLocationException {
        Document document = this.textArea.getDocument();
        TextUI textUI = this.textArea.getUI();
        HighlightInfo highlightInfo = this.getDrawsLayeredHighlights() ? new LayeredHighlightInfo() : new HighlightInfo();
        highlightInfo.painter = markOccurrencesHighlightPainter;
        highlightInfo.p0 = document.createPosition(n);
        highlightInfo.p1 = document.createPosition(n2 - 1);
        this.markedOccurrences.add(highlightInfo);
        textUI.damageRange(this.textArea, n, n2);
        return highlightInfo;
    }

    public void deinstall(JTextComponent jTextComponent) {
        this.textArea = null;
        this.markedOccurrences.clear();
    }

    public void install(JTextComponent jTextComponent) {
        super.install(jTextComponent);
        this.textArea = (RTextArea)jTextComponent;
    }

    public void paint(Graphics graphics) {
        int n = this.markedOccurrences.size();
        for (int i = 0; i < n; ++i) {
            HighlightInfo highlightInfo = (HighlightInfo)this.markedOccurrences.get(i);
            if (highlightInfo instanceof LayeredHighlightInfo) continue;
            Rectangle rectangle = this.textArea.getBounds();
            Insets insets = this.textArea.getInsets();
            rectangle.x = insets.left;
            rectangle.y = insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            while (i < n) {
                highlightInfo = (HighlightInfo)this.markedOccurrences.get(i);
                if (!(highlightInfo instanceof LayeredHighlightInfo)) {
                    Highlighter.HighlightPainter highlightPainter = highlightInfo.getPainter();
                    highlightPainter.paint(graphics, highlightInfo.getStartOffset(), highlightInfo.getEndOffset(), rectangle, this.textArea);
                }
                ++i;
            }
        }
        super.paint(graphics);
    }

    public void paintLayeredHighlights(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
        for (int i = this.markedOccurrences.size() - 1; i >= 0; --i) {
            Object e = this.markedOccurrences.get(i);
            if (!(e instanceof LayeredHighlightInfo)) continue;
            LayeredHighlightInfo layeredHighlightInfo = (LayeredHighlightInfo)e;
            int n3 = layeredHighlightInfo.getStartOffset();
            int n4 = layeredHighlightInfo.getEndOffset();
            if ((n >= n3 || n2 <= n3) && (n < n3 || n >= n4)) continue;
            layeredHighlightInfo.paintLayeredHighlights(graphics, n, n2, shape, jTextComponent, view);
        }
        super.paintLayeredHighlights(graphics, n, n2, shape, jTextComponent, view);
    }

    void removeMarkOccurrencesHighlight(Object object) {
        if (object instanceof LayeredHighlightInfo) {
            LayeredHighlightInfo layeredHighlightInfo = (LayeredHighlightInfo)object;
            if (layeredHighlightInfo.width > 0 && layeredHighlightInfo.height > 0) {
                this.textArea.repaint(layeredHighlightInfo.x, layeredHighlightInfo.y, layeredHighlightInfo.width, layeredHighlightInfo.height);
            }
        } else {
            HighlightInfo highlightInfo = (HighlightInfo)object;
            TextUI textUI = this.textArea.getUI();
            textUI.damageRange(this.textArea, highlightInfo.getStartOffset(), highlightInfo.getEndOffset());
        }
        this.markedOccurrences.remove(object);
    }

    private static class LayeredHighlightInfo
    extends HighlightInfo {
        private int x;
        private int y;
        private int width;
        private int height;

        private LayeredHighlightInfo() {
        }

        void union(Shape shape) {
            Rectangle rectangle;
            if (shape == null) {
                return;
            }
            Rectangle rectangle2 = rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            if (this.width == 0 || this.height == 0) {
                this.x = rectangle.x;
                this.y = rectangle.y;
                this.width = rectangle.width;
                this.height = rectangle.height;
            } else {
                this.width = Math.max(this.x + this.width, rectangle.x + rectangle.width);
                this.height = Math.max(this.y + this.height, rectangle.y + rectangle.height);
                this.x = Math.min(this.x, rectangle.x);
                this.width -= this.x;
                this.y = Math.min(this.y, rectangle.y);
                this.height -= this.y;
            }
        }

        void paintLayeredHighlights(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
            int n3 = this.getStartOffset();
            int n4 = this.getEndOffset();
            n = Math.max(n3, n);
            n2 = Math.min(n4, n2);
            this.union(((LayeredHighlighter.LayerPainter)this.painter).paintLayer(graphics, n, n2, shape, jTextComponent, view));
        }
    }

    private static class HighlightInfo
    implements Highlighter.Highlight {
        private Position p0;
        private Position p1;
        protected Highlighter.HighlightPainter painter;

        private HighlightInfo() {
        }

        public int getStartOffset() {
            return this.p0.getOffset();
        }

        public int getEndOffset() {
            return this.p1.getOffset();
        }

        public Highlighter.HighlightPainter getPainter() {
            return this.painter;
        }
    }
}

