/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.fife.io.DocumentReader;
import org.fife.ui.rsyntaxtextarea.Parser;
import org.fife.ui.rsyntaxtextarea.ParserNotice;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

class ParserManager
implements DocumentListener,
ActionListener {
    private RSyntaxTextArea textArea;
    private Parser parser;
    private Timer timer;
    private static final boolean DEBUG_PARSING = true;
    private static final int DEFAULT_DELAY_MS = 1250;

    public ParserManager(RSyntaxTextArea rSyntaxTextArea) {
        this(1250, rSyntaxTextArea);
    }

    public ParserManager(int n, RSyntaxTextArea rSyntaxTextArea) {
        this.textArea = rSyntaxTextArea;
        this.timer = new Timer(n, this);
        this.timer.setRepeats(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.parser == null) {
            return;
        }
        long l = 0L;
        l = System.currentTimeMillis();
        RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)this.textArea.getDocument();
        rSyntaxDocument.readLock();
        try {
            DocumentReader documentReader = new DocumentReader(rSyntaxDocument);
            this.parser.parse(documentReader);
            documentReader.close();
        }
        finally {
            rSyntaxDocument.readUnlock();
        }
        float f = (float)(System.currentTimeMillis() - l) / 1000.0f;
        System.err.println("Parsing took: " + f + " seconds");
        this.textArea.refreshParserNoticeHighlights(this.parser.getNoticeIterator());
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public int getDelay() {
        return this.timer.getDelay();
    }

    public Parser getParser() {
        return this.parser;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        int n = this.textArea.viewToModel(mouseEvent.getPoint());
        Iterator iterator = this.parser.getNoticeIterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                ParserNotice parserNotice = (ParserNotice)iterator.next();
                if (!parserNotice.containsPosition(n)) continue;
                return parserNotice.getMessage();
            }
        }
        return null;
    }

    public void handleDocumentEvent(DocumentEvent documentEvent) {
        this.timer.restart();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.handleDocumentEvent(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.handleDocumentEvent(documentEvent);
    }

    public void setDelay(int n) {
        boolean bl = this.timer.isRunning();
        this.timer.stop();
        this.timer.setDelay(n);
        if (bl) {
            this.timer.start();
        }
    }

    public void setParser(Parser parser) {
        if (this.parser != null) {
            this.timer.stop();
            this.textArea.getDocument().removeDocumentListener(this);
        }
        this.parser = parser;
        if (parser != null) {
            ToolTipManager.sharedInstance().registerComponent(this.textArea);
            this.textArea.getDocument().addDocumentListener(this);
            this.timer.start();
        }
    }
}

