/*
 * *##% 
 * Nuiton Processor :: Ant task
 * Copyright (C) 2009 - 2010 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*
 */

package org.nuiton.processor.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.nuiton.processor.I18nExtractor;

/**
 * I18nExtractorTask.
 *
 * Created: Aug 16, 2004
 *
 * @author Cédric Pineau <pineau@codelutin.com>
 * @version $Revision: 317 $
 *
 * Last update : $Date: 2010-03-09 19:22:11 +0100 (mar., 09 mars 2010) $
 * by : $Author: tchemit $
 * @deprecated since 1.0.3, prefer use the same task in ant-i18n-task project.
 */
@Deprecated
public class I18nExtractorTask extends MatchingTask {

    public static final int MSG_VERBOSE = Project.MSG_VERBOSE;

    protected File srcDir;

    protected File destFile;

    protected String[] includes = EMPTY_STRING_ARRAY;

    protected String[] excludes = EMPTY_STRING_ARRAY;

    protected String[] srcFileNames;

    private static final String[] EMPTY_STRING_ARRAY = new String[] {};

    public I18nExtractorTask() {

    }

    protected void doExecute() throws BuildException {
        // creation du repertoire pour le fichier destination
        File parentFile = destFile.getParentFile();
        if (!parentFile.exists()) {
            boolean b = parentFile.mkdirs();
            if (!b) {
                throw new BuildException(
                        "could not create directory " + parentFile);
            }
        }
        List<File> fileList = new ArrayList<File>();
        for (String srcFileName : srcFileNames) {
            fileList.add(new File(srcFileName));
        }
        try {
            new I18nExtractor().extract(
                    fileList.toArray(new File[fileList.size()]), destFile);
        } catch (IOException eee) {
            throw new BuildException(eee);
        }
    }

    public void setSrcdir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setDestFile(File destFile) {
        this.destFile = destFile;
    }

    @Override
    public void execute() throws BuildException {
        // first of all, make sure that we've got a srcdir
        if (srcDir == null) {
            throw new BuildException("srcdir attribute must be set!",
                    getLocation());
        }
        if (!srcDir.exists()) {
            throw new BuildException("srcdir \"" + srcDir.getPath()
                    + "\" does not exist!", getLocation());
        }

        if (destFile == null) {
            throw new BuildException("destFile attribute must be set!",
                    getLocation());
        }

        // Build the list of files to compute
        buildFileList();

        // generate the source files
        doExecute();
    }

    protected void buildFileList() {

        // Obtain this list of files within the source directory
        DirectoryScanner ds = getDirectoryScanner(srcDir);

        String[] ins = getIncludes();
        if (ins.length > 0) {
            ds.setIncludes(ins);
        }
        String[] exs = getExcludes();
        if (exs.length > 0) {
            ds.setExcludes(exs);
        }

        ds.scan();

        // on met le resultat dans files
        srcFileNames = ds.getIncludedFiles();
    }

    protected boolean isNewer(String filein, String fileout) {
        boolean result = new File(filein).lastModified() > new File(fileout)
                .lastModified();
        if (result) {
            log(filein + " is newer than " + fileout, MSG_VERBOSE);
        }
        return result;
    }

    protected String[] getExcludes() {
        return excludes;
    }

    protected String[] getIncludes() {
        return includes;
    }

    @Override
    public void setIncludes(String includes) {
        this.includes = includes.split(",");
    }

    @Override
    public void setExcludes(String excludes) {
        this.excludes = excludes.split(",");
    }

}
