/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util.rmi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.ConnectException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.rmi.RemoteMethodExecutor;
import org.nuiton.util.rmi.ServiceExporter;

public class RemoteProxyFactory {
    private static final Log log = LogFactory.getLog(RemoteProxyFactory.class);
    protected static final int PORT = 12345;
    protected static final String REGISTRY_IP = "127.0.0.1";

    public static <T> T createProxy(Class<T> serviceInterface) throws RemoteException, NotBoundException {
        String rmiName = serviceInterface.getName();
        T result = RemoteProxyFactory.createProxy(rmiName, serviceInterface);
        return result;
    }

    public static <T> T createProxy(String rmiName, Class<T> serviceInterface) throws RemoteException, NotBoundException {
        Registry registry = LocateRegistry.getRegistry(REGISTRY_IP, 12345);
        try {
            registry.list();
        }
        catch (ConnectException ce) {
            registry = LocateRegistry.getRegistry();
        }
        final RemoteMethodExecutor stub = (RemoteMethodExecutor)registry.lookup(rmiName);
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object result;
                String methodName = method.getName();
                Class<?>[] parametersType = method.getParameterTypes();
                try {
                    result = stub.execute(methodName, parametersType, args);
                }
                catch (ServerException se) {
                    Throwable cause;
                    if (log.isInfoEnabled()) {
                        log.info("Server exception: " + se.getMessage());
                    }
                    if ((cause = se.getCause()) instanceof RemoteException) {
                        RemoteException re = (RemoteException)cause;
                        cause = re.getCause();
                    }
                    throw cause;
                }
                return result;
            }
        };
        Object proxy = Proxy.newProxyInstance(ServiceExporter.class.getClassLoader(), new Class[]{serviceInterface}, handler);
        return (T)proxy;
    }
}

