/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.primitives.ArrayLongList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.StringUtil;

public class CallAnalyse {
    private static final Log log = LogFactory.getLog(CallAnalyse.class);
    private static List<ThreadStatistics> listThreadStatistics = new ArrayList<ThreadStatistics>();
    private static ThreadLocal<ThreadStatistics> stats = new ThreadLocal<ThreadStatistics>(){

        @Override
        protected synchronized ThreadStatistics initialValue() {
            ThreadStatistics result = new ThreadStatistics();
            listThreadStatistics.add(result);
            return result;
        }
    };

    public static void activate() {
        stats.get().setActivated(true);
    }

    public static void desactivate() {
        stats.get().setActivated(false);
    }

    public static boolean isActivate() {
        return stats.get().getActivated();
    }

    public static void enter(String name) {
        ThreadStatistics t = stats.get();
        if (t.getActivated()) {
            t.get(name).enter();
        }
    }

    public static void exit(String name) {
        ThreadStatistics t = stats.get();
        if (t.getActivated()) {
            t.get(name).exit();
        }
    }

    public static ThreadStatistics getThreadStatistics() {
        return stats.get();
    }

    public static List<ThreadStatistics> getAllThreadStatistics() {
        return listThreadStatistics;
    }

    public static Map<String, CallStatisticsSummary> getSummary() {
        HashMap<String, CallStatisticsSummary> results = new HashMap<String, CallStatisticsSummary>();
        for (ThreadStatistics stats : CallAnalyse.getAllThreadStatistics()) {
            for (String name : stats.keySet()) {
                CallStatisticsSummary stat = (CallStatisticsSummary)results.get(name);
                if (stat == null) {
                    stat = new CallStatisticsSummary(name);
                    results.put(name, stat);
                }
                stat.addCallStats(stats.get(name));
            }
        }
        return results;
    }

    public static class CallStatisticsSummary
    extends CallStatistics {
        public CallStatisticsSummary(String name) {
            super(name);
        }

        public void addCallStats(CallStatistics other) {
            if (other == null || this.equals(other)) {
                return;
            }
            this.calls += other.getCalls();
            if (other.getMinTime() < this.minTime || this.minTime == Long.MAX_VALUE) {
                this.minTime = other.getMinTime();
            }
            if (other.getMaxTime() > this.maxTime) {
                this.maxTime = other.getMaxTime();
            }
            this.sumTime += other.getSumTime();
            if (other.getMinMemory() < this.minMemory || this.minMemory == Long.MAX_VALUE) {
                this.minMemory = other.getMinMemory();
            }
            if (other.getMaxMemory() > this.maxMemory) {
                this.maxMemory = other.getMaxMemory();
            }
            this.sumMemory += other.getSumMemory();
        }
    }

    public static class CallStatistics
    implements Cloneable {
        protected String name = null;
        protected long calls = 0L;
        protected long minTime = Long.MAX_VALUE;
        protected long maxTime = Long.MIN_VALUE;
        protected long sumTime = 0L;
        protected long minMemory = Long.MAX_VALUE;
        protected long maxMemory = Long.MIN_VALUE;
        protected long sumMemory = 0L;
        protected ArrayLongList times = new ArrayLongList();
        protected ArrayLongList memories = new ArrayLongList();
        protected Runtime runtime = Runtime.getRuntime();

        public CallStatistics(String name) {
            this.name = name;
        }

        public void enter() {
            this.times.add(System.nanoTime());
            this.memories.add(this.getMemory());
        }

        public void exit() {
            ++this.calls;
            if (this.times.size() == 0) {
                log.info("To many exit call for " + this.name);
                return;
            }
            long time = this.times.removeElementAt(this.times.size() - 1);
            time = System.nanoTime() - time;
            if (time < this.minTime || this.minTime == Long.MAX_VALUE) {
                this.minTime = time;
            }
            if (time > this.maxTime) {
                this.maxTime = time;
            }
            this.sumTime += time;
            long memory = this.memories.removeElementAt(this.memories.size() - 1);
            memory = this.getMemory() - memory;
            if (memory < this.minMemory || this.minMemory == Long.MAX_VALUE) {
                this.minMemory = memory;
            }
            if (memory > this.maxMemory) {
                this.maxMemory = memory;
            }
            this.sumMemory += memory;
        }

        public String getName() {
            return this.name;
        }

        public long getCalls() {
            return this.calls;
        }

        public long getMinTime() {
            return this.minTime;
        }

        public long getMaxTime() {
            return this.maxTime;
        }

        public long getSumTime() {
            return this.sumTime;
        }

        public long getAvgTime() {
            if (this.calls == 0L) {
                return 0L;
            }
            return this.sumTime / this.calls;
        }

        public long getMinMemory() {
            return this.minMemory;
        }

        public long getMaxMemory() {
            return this.maxMemory;
        }

        public long getSumMemory() {
            return this.sumMemory;
        }

        public long getAvgMemory() {
            if (this.calls == 0L) {
                return 0L;
            }
            return this.sumMemory / this.calls;
        }

        protected long getMemory() {
            return this.runtime.totalMemory() - this.runtime.freeMemory();
        }

        public String toString() {
            return this.getName() + " calls=" + this.getCalls() + " time=" + StringUtil.convertTime(this.getSumTime()) + "(" + StringUtil.convertTime(this.getMinTime()) + "/" + StringUtil.convertTime(this.getAvgTime()) + "/" + StringUtil.convertTime(this.getMaxTime()) + ")" + " memory=" + StringUtil.convertMemory(this.getSumMemory()) + "(" + StringUtil.convertMemory(this.getMinMemory()) + "/" + StringUtil.convertMemory(this.getAvgMemory()) + "/" + StringUtil.convertMemory(this.getMaxMemory()) + ")";
        }
    }

    public static class ThreadStatistics
    extends TreeMap<String, CallStatistics> {
        private static final long serialVersionUID = -36051448464013504L;
        protected boolean activated = false;

        public boolean getActivated() {
            return this.activated;
        }

        public void setActivated(boolean activated) {
            this.activated = activated;
        }

        public CallStatistics get(String name) {
            CallStatistics result = (CallStatistics)super.get(name);
            if (result == null) {
                result = new CallStatistics(name);
                this.put(name, result);
            }
            return result;
        }

        @Override
        public String toString() {
            return this.values().toString();
        }
    }
}

