/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.StringUtil;

public class TimeLog {
    protected Log timeLog;
    protected long timeToLogInfo = 1000000000L;
    protected long timeToLogWarn = 3000000000L;
    protected Map<String, CallStat> callCount = new HashMap<String, CallStat>();

    protected TimeLog(Log logTime) {
        this.timeLog = logTime;
    }

    public TimeLog(String logName) {
        this(LogFactory.getLog(logName + ".TimeLog"));
    }

    public TimeLog(Class<?> logName) {
        this(logName.getName());
    }

    public TimeLog(String logName, long timeToLogInfo, long timeToLogWarn) {
        this(logName);
        this.setTimeToLogInfo(timeToLogInfo);
        this.setTimeToLogWarn(timeToLogWarn);
    }

    public TimeLog(Class<?> logName, long timeToLogInfo, long timeToLogWarn) {
        this(logName.getName(), timeToLogInfo, timeToLogWarn);
    }

    public void setTimeToLogInfo(long timeToLogInfoMs) {
        this.timeToLogInfo = timeToLogInfoMs * 1000000L;
    }

    public void setTimeToLogWarn(long timeToLogWarnMs) {
        this.timeToLogWarn = timeToLogWarnMs * 1000000L;
    }

    public Map<String, CallStat> getCallCount() {
        return this.callCount;
    }

    public static long getTime() {
        return System.nanoTime();
    }

    public long log(long startNs, String methodName) {
        long result = this.log(startNs, TimeLog.getTime(), methodName, "");
        return result;
    }

    public long log(long startNs, String methodName, String msg) {
        long result = this.log(startNs, TimeLog.getTime(), methodName, msg);
        return result;
    }

    public long log(long startNs, long stopNs, String methodName, String msg) {
        long time = stopNs - startNs;
        CallStat calls = this.callCount.get(methodName);
        if (calls == null) {
            calls = new CallStat();
            this.callCount.put(methodName, calls);
        }
        ++calls.callNumber;
        calls.callTime += time;
        if (calls.maxCallTime < time) {
            calls.maxCallTime = time;
        }
        if (calls.minCallTime > time) {
            calls.minCallTime = time;
        }
        String timeString = StringUtil.convertTime(time);
        String message = String.format("[%s] for method '%s', %s (%s)", timeString, methodName, msg, calls);
        if (time > this.timeToLogWarn && this.timeLog.isWarnEnabled()) {
            this.timeLog.warn(message);
        } else if (time > this.timeToLogInfo && this.timeLog.isInfoEnabled()) {
            this.timeLog.info(message);
        } else if (this.timeLog.isDebugEnabled()) {
            this.timeLog.debug(message);
        }
        return stopNs;
    }

    public static class CallStat {
        protected long callNumber;
        protected long maxCallTime = 0L;
        protected long minCallTime = Integer.MAX_VALUE;
        protected long callTime;

        public String toString() {
            String callTimeString = StringUtil.convertTime(this.callTime);
            String avgTimeString = StringUtil.convertTime(this.callTime / this.callNumber);
            String minCallTimeString = StringUtil.convertTime(this.minCallTime);
            String maxCallTimeString = StringUtil.convertTime(this.maxCallTime);
            return String.format("total call %s, total time %s, min time %s, max time %s, avg time %s", this.callNumber, callTimeString, minCallTimeString, maxCallTimeString, avgTimeString);
        }
    }
}

