/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.nuiton.math.matrix.MatrixHelper;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;

public class MatrixEncoder {
    protected Writer out = null;

    public MatrixEncoder(Writer out) {
        this.out = out;
    }

    protected String getSemanticsAsXml(Object o) throws IOException {
        String xml = null;
        if (o != null) {
            String type = String.class.getName();
            if (o instanceof Number || o instanceof Boolean) {
                type = o.getClass().getName();
            }
            xml = "<object type=\"" + type + "\">" + o.toString() + "</object>";
        }
        return xml;
    }

    public void writeMatrice(MatrixND mat) throws IOException {
        int i;
        double defaultValue = mat.getMaxOccurrence();
        this.out.write("<matrix defaultValue=\"" + defaultValue + "\" name=\"" + mat.getName() + "\" dimensions=\"");
        this.out.write(MatrixHelper.coordinatesToString(mat.getDim()));
        this.out.write("\" type=\"" + mat.getClass().getName() + "\">\n");
        for (i = 0; i < mat.getDimCount(); ++i) {
            String dimName = mat.getDimensionName(i);
            if (dimName == null || "".equals(dimName)) continue;
            this.out.write("  <dimensionName dim=\"" + i + "\">");
            this.out.write(mat.getDimensionName(i));
            this.out.write("</dimensionName>\n");
        }
        for (i = 0; i < mat.getDimCount(); ++i) {
            String xml;
            List<?> sem = mat.getSemantic(i);
            ArrayList<String> semAsXml = new ArrayList<String>();
            boolean haveNotNull = false;
            Iterator<?> e = sem.iterator();
            while (e.hasNext()) {
                xml = this.getSemanticsAsXml(e.next());
                semAsXml.add(xml);
                haveNotNull = haveNotNull || xml != null;
            }
            if (!haveNotNull) continue;
            this.out.write("  <semantics dim=\"" + i + "\">\n");
            for (int index = 0; index < semAsXml.size(); ++index) {
                xml = (String)semAsXml.get(index);
                if (xml == null) continue;
                this.out.write("    <sem index=\"" + index + "\">" + xml + "</sem>\n");
            }
            this.out.write("  </semantics>\n");
        }
        MatrixIterator i2 = mat.iterator();
        while (i2.next()) {
            double val = i2.getValue();
            if (val == defaultValue) continue;
            String path = MatrixHelper.coordinatesToString(i2.getCoordinates());
            this.out.write("\t<element path=\"" + path + "\" value=\"" + val + "\"/>\n");
        }
        this.out.write("</matrix>\n");
    }
}

