/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.DoubleBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.nuiton.math.matrix.MapFunction;
import org.nuiton.math.matrix.MatrixHelper;
import org.nuiton.math.matrix.Vector;

public class DoubleBigMappedVector
implements Vector {
    public static final int DOUBLE_SIZE = 8;
    protected File file;
    protected int capacity;
    protected DoubleBuffer data = null;

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.file != null) {
            this.file.delete();
        }
    }

    public DoubleBigMappedVector(int capacity) throws IOException {
        this.capacity = capacity;
        this.file = File.createTempFile("matrix", ".mapped");
        this.file.deleteOnExit();
        RandomAccessFile raf = new RandomAccessFile(this.file, "rw");
        this.data = raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, capacity * 8).asDoubleBuffer();
    }

    public DoubleBigMappedVector(RandomAccessFile raf, long offset, int capacity) throws IOException {
        this(raf.getChannel().map(FileChannel.MapMode.READ_WRITE, offset, capacity * 8).asDoubleBuffer(), capacity);
    }

    public DoubleBigMappedVector(MappedByteBuffer bytes, int capacity) {
        this(bytes.asDoubleBuffer(), capacity);
    }

    public DoubleBigMappedVector(DoubleBuffer data, int capacity) {
        this.capacity = capacity;
        this.data = data;
    }

    @Override
    public int size() {
        return this.capacity;
    }

    @Override
    @Deprecated
    public double getMaxOccurence() {
        return this.getMaxOccurrence();
    }

    @Override
    public double getMaxOccurrence() {
        this.data.position(0);
        double[] tmp = new double[this.capacity];
        this.data.get(tmp);
        return MatrixHelper.maxOccurrence(tmp);
    }

    @Override
    public double getValue(int pos) {
        return this.data.get(pos);
    }

    @Override
    public void setValue(int pos, double value) {
        this.data.put(pos, value);
    }

    public boolean equals(Object o) {
        boolean result;
        boolean bl = result = this == o;
        if (!result) {
            if (o instanceof DoubleBigMappedVector) {
                DoubleBigMappedVector other = (DoubleBigMappedVector)o;
                other.data.position(0);
                this.data.position(0);
                result = this.data.equals(other.data);
            } else if (o instanceof Vector) {
                Vector other = (Vector)o;
                result = true;
                for (int i = 0; i < this.size() && result; ++i) {
                    result = this.getValue(i) == other.getValue(i);
                }
            }
        }
        return result;
    }

    @Override
    public boolean isImplementedPaste(Vector v) {
        return v instanceof DoubleBigMappedVector;
    }

    @Override
    public boolean isImplementedAdd(Vector v) {
        return v instanceof DoubleBigMappedVector;
    }

    @Override
    public boolean isImplementedMinus(Vector v) {
        return v instanceof DoubleBigMappedVector;
    }

    @Override
    public boolean isImplementedMap() {
        return true;
    }

    @Override
    public void paste(Vector src) {
        DoubleBigMappedVector dbmSrc = (DoubleBigMappedVector)src;
        dbmSrc.data.position(0);
        this.data.position(0);
        this.data.put(dbmSrc.data);
    }

    @Override
    public void add(Vector v) {
        DoubleBigMappedVector fbv = (DoubleBigMappedVector)v;
        for (int i = 0; i < this.capacity; ++i) {
            double value = this.data.get(i);
            this.data.put(i, value += fbv.data.get(i));
        }
    }

    @Override
    public void minus(Vector v) {
        DoubleBigMappedVector fbv = (DoubleBigMappedVector)v;
        for (int i = 0; i < this.capacity; ++i) {
            double value = this.data.get(i);
            this.data.put(i, value -= fbv.data.get(i));
        }
    }

    @Override
    public void map(MapFunction f) {
        for (int i = 0; i < this.capacity; ++i) {
            double v = this.data.get(i);
            v = f.apply(v);
            this.data.put(i, v);
        }
    }
}

