/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;
import org.nuiton.jredmine.model.Version;
import org.nuiton.jredmine.plugin.AbstractRedmineMojoWithProject;
import org.nuiton.jredmine.plugin.RedmineVersionAware;
import org.nuiton.jredmine.service.RedmineServiceException;

public abstract class AbstractRedmineMojoWithProjectAndVersion
extends AbstractRedmineMojoWithProject
implements RedmineVersionAware {
    @Parameter(property="redmine.versionId", defaultValue="${project.version}")
    protected String versionId;
    protected Version releaseVersion;
    private final boolean requireVersion;
    private Version[] projectVersions;

    protected AbstractRedmineMojoWithProjectAndVersion(boolean requireUser, boolean requireVersion) {
        super(requireUser);
        this.requireVersion = requireVersion;
    }

    @Override
    public final String getVersionId() {
        return this.versionId;
    }

    @Override
    public final void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    @Override
    protected void init() throws Exception {
        super.init();
        if (this.initOk) {
            boolean r;
            try {
                this.projectVersions = this.service.getVersions(this.projectId);
            }
            catch (RedmineServiceException e) {
                this.getLog().warn((CharSequence)("could not retrieve project versions, for reason " + e.getMessage()), (Throwable)e);
                this.initOk = false;
            }
            if (this.initOk && this.requireVersion && !(r = this.initReleaseVersion())) {
                this.failIfSafe("the version '" + this.versionId + "' could not be retrieve from redmine server.");
                this.initOk = false;
            }
        }
    }

    @Override
    protected boolean checkSkip() {
        boolean canContinue = super.checkSkip();
        if (canContinue && this.requireVersion && this.releaseVersion == null) {
            this.getLog().error((CharSequence)("the version '" + this.versionId + "' could not be retrieve from redmine server, goal is skip"));
            canContinue = false;
        }
        return canContinue;
    }

    protected Version[] getProjectVersions() {
        return this.projectVersions;
    }

    protected Version getProjectVersion(String versionId) {
        Version v = Version.byVersionName((String)versionId, (Version[])this.projectVersions);
        return v;
    }

    protected boolean initReleaseVersion() throws MojoExecutionException {
        if (StringUtils.isBlank((String)this.versionId)) {
            throw new MojoExecutionException("required a versionId parameter");
        }
        this.releaseVersion = this.getProjectVersion(this.versionId);
        return this.releaseVersion != null;
    }
}

