/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jredmine.plugin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.nuiton.io.rest.RequestFactory;
import org.nuiton.io.rest.RestRequestBuilder;
import org.nuiton.jredmine.RedmineServiceImplementor;
import org.nuiton.jredmine.model.I18nAble;
import org.nuiton.jredmine.model.IdAble;
import org.nuiton.jredmine.model.Issue;
import org.nuiton.jredmine.model.IssueCategory;
import org.nuiton.jredmine.model.IssuePriority;
import org.nuiton.jredmine.model.IssueStatus;
import org.nuiton.jredmine.model.ModelHelper;
import org.nuiton.jredmine.model.News;
import org.nuiton.jredmine.model.Project;
import org.nuiton.jredmine.model.Tracker;
import org.nuiton.jredmine.model.User;
import org.nuiton.jredmine.model.Version;
import org.nuiton.jredmine.plugin.AbstractRedmineMojo;
import org.nuiton.jredmine.plugin.RedmineProjectAware;
import org.nuiton.jredmine.plugin.RedmineVersionAware;
import org.nuiton.jredmine.rest.RedmineRequestFactory;
import org.nuiton.plugin.PluginHelper;

@Mojo(name="display-data", requiresOnline=true, requiresProject=true)
public class DisplayDataMojo
extends AbstractRedmineMojo
implements RedmineProjectAware,
RedmineVersionAware {
    @Parameter(property="redmine.projectId", defaultValue="${project.artifactId}", required=true)
    protected String projectId;
    @Parameter(property="redmine.versionId", defaultValue="${project.version}")
    protected String versionId;
    @Parameter(property="types", required=true)
    protected String types;
    @Parameter(property="sortById", defaultValue="true", required=true)
    protected boolean sortById;
    @Parameter(property="anonymous", defaultValue="true")
    protected boolean anonymous;
    protected Map<String, Class<?>> actions;
    private final Map<Class<?>, String> typesToRequestName = Maps.newHashMap();
    private final Map<String, Class<?>> namesToType;

    public DisplayDataMojo() {
        this.typesToRequestName.put(Project.class, "Project/all");
        this.typesToRequestName.put(Version.class, "Project/Version/all");
        this.typesToRequestName.put(Issue.class, "Project/Version/Issue/all");
        this.typesToRequestName.put(News.class, "Project/News/all");
        this.typesToRequestName.put(IssueStatus.class, "IssueStatus/all");
        this.typesToRequestName.put(IssuePriority.class, "IssuePriority/all");
        this.typesToRequestName.put(IssueCategory.class, "IssueCategory/all");
        this.typesToRequestName.put(Tracker.class, "Project/Tracker/all");
        this.typesToRequestName.put(User.class, "Project/User/all");
        this.namesToType = Maps.newHashMap();
        this.namesToType.put("project", Project.class);
        this.namesToType.put("version", Version.class);
        this.namesToType.put("issue", Issue.class);
        this.namesToType.put("news", News.class);
        this.namesToType.put("issuestatus", IssueStatus.class);
        this.namesToType.put("issuepriority", IssuePriority.class);
        this.namesToType.put("issuecategory", IssueCategory.class);
        this.namesToType.put("tracker", Tracker.class);
        this.namesToType.put("user", User.class);
    }

    @Override
    protected boolean checkRunOnceDone() {
        return false;
    }

    @Override
    protected boolean isGoalSkip() {
        return false;
    }

    @Override
    protected boolean isRunOnce() {
        return false;
    }

    @Override
    protected void init() throws Exception {
        if (this.versionId != null) {
            this.versionId = PluginHelper.removeSnapshotSuffix((String)this.versionId);
        }
        super.init();
        this.actions = this.getDownloadActions();
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    @Override
    public String getVersionId() {
        return this.versionId;
    }

    @Override
    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    @Override
    protected boolean checkSkip() {
        boolean canContinue;
        if (this.actions == null || this.actions.isEmpty()) {
            this.getLog().warn((CharSequence)"No data types detected, you must fill the required parameter types, will skip goal");
            canContinue = false;
        } else {
            canContinue = super.checkSkip();
        }
        return canContinue;
    }

    @Override
    protected void doAction() throws Exception {
        StringBuilder buffer = new StringBuilder("\n");
        for (Map.Entry<String, Class<?>> entry : this.actions.entrySet()) {
            Class<?> type = entry.getValue();
            String dataTypeName = entry.getKey();
            String scope = this.getDataScope(type);
            String requestName = this.typesToRequestName.get(type);
            RedmineServiceImplementor implementor = this.service.getDelegateImplementor();
            IdAble[] datas = "version".equals(scope) ? (IdAble[])implementor.getDatas(requestName, type, new Object[]{this.projectId, this.versionId}) : ("project".equals(scope) ? (IdAble[])implementor.getDatas(requestName, type, new Object[]{this.projectId}) : (IdAble[])implementor.getDatas(requestName, type, new Object[0]));
            List<IdAble> list = Arrays.asList(datas);
            if (this.sortById) {
                Collections.sort(list, ModelHelper.ID_ABLE_COMPARATOR);
            }
            buffer.append("\nValues of '").append(dataTypeName).append('\'');
            if ("version".equals(scope) || "project".equals(scope)) {
                buffer.append(" for project '").append(this.projectId).append("'");
            }
            if ("version".equals(scope)) {
                buffer.append(" and version '").append(this.versionId).append("'");
            }
            buffer.append('\n');
            for (IdAble data : list) {
                buffer.append("  - ");
                buffer.append(data.getId());
                buffer.append(" = ");
                buffer.append(((I18nAble)data).getName());
                buffer.append('\n');
            }
        }
        System.out.println(buffer.toString());
    }

    protected Map<String, Class<?>> getDownloadActions() throws MojoFailureException {
        TreeMap results = Maps.newTreeMap();
        ArrayList universeList = Lists.newArrayList(this.typesToRequestName.keySet());
        for (String dataType : this.types.split(",")) {
            Class<?> result = this.namesToType.get(dataType = dataType.toLowerCase(Locale.ENGLISH));
            if (result == null || !universeList.contains(result)) {
                throw new MojoFailureException("The data type '" + result + "' can not be used, Accepted types are : " + universeList);
            }
            String scope = this.getDataScope(result);
            if (("version".equals(scope) || "project".equals(scope)) && (this.projectId == null || this.projectId.isEmpty())) {
                throw new MojoFailureException("The data type '" + result + "', depends on a project, but the 'projectId' was " + "not filled.");
            }
            if ("version".equals(scope) && (this.versionId == null || this.versionId.isEmpty())) {
                throw new MojoFailureException("The data type '" + result + "', depends on a version, but the 'versionId' was " + "not filled.");
            }
            results.put(dataType, result);
        }
        return results;
    }

    protected String getDataScope(Class<?> type) {
        RequestFactory requestFactory = this.service.getDelegateImplementor().getSession().getRequestFactory();
        String requestName = this.typesToRequestName.get(type);
        RestRequestBuilder requestBuilder = requestFactory.getRequestBuilder(requestName);
        return RedmineRequestFactory.getRequestScope((RestRequestBuilder)requestBuilder);
    }
}

