/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.datetime;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import jaxx.runtime.spi.UIHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.ModelToBean;
import org.nuiton.jaxx.widgets.MutateOnConditionalPropertyChangeListener;
import org.nuiton.jaxx.widgets.datetime.DateTimeEditor;
import org.nuiton.jaxx.widgets.datetime.DateTimeEditorModel;
import org.nuiton.jaxx.widgets.datetime.TimeSliderInitializer;
import org.nuiton.util.beans.BeanUtil;

public class DateTimeEditorHandler
implements UIHandler<DateTimeEditor> {
    private static final Log log = LogFactory.getLog(DateTimeEditorHandler.class);
    protected DateTimeEditor ui;
    protected final Calendar calendarMinute = new GregorianCalendar();
    protected final Calendar calendarHour = new GregorianCalendar();

    public void beforeInit(DateTimeEditor ui) {
        DateTimeEditorModel model = new DateTimeEditorModel();
        ui.setContextValue(model);
        this.ui = ui;
    }

    public void afterInit(DateTimeEditor ui) {
        ui.getMinuteEditor().setEditor(new JSpinner.DateEditor(ui.getMinuteEditor(), "mm"));
        ui.getHourEditor().setEditor(new JSpinner.DateEditor(ui.getHourEditor(), "HH"));
        JSlider slider = ui.getSlider();
        TimeSliderInitializer timeSliderInitializer = new TimeSliderInitializer();
        timeSliderInitializer.init(slider);
    }

    public void init(DateTimeEditor ui) {
        DateTimeEditorModel model = ui.getModel();
        Serializable bean = model.getBean();
        if (bean != null) {
            Method mutator;
            Predicate<DateTimeEditorModel> predicate = model.canUpdateBeanValuePredicate();
            if (model.getPropertyDayDate() != null) {
                mutator = BeanUtil.getMutator((Object)bean, (String)model.getPropertyDayDate());
                Preconditions.checkNotNull((Object)mutator, (Object)("could not find mutator for " + model.getPropertyDayDate()));
                model.addPropertyChangeListener("dayDate", (PropertyChangeListener)new MutateOnConditionalPropertyChangeListener((ModelToBean)model, mutator, predicate));
            }
            if (model.getPropertyTimeDate() != null) {
                mutator = BeanUtil.getMutator((Object)bean, (String)model.getPropertyTimeDate());
                Preconditions.checkNotNull((Object)mutator, (Object)("could not find mutator for " + model.getPropertyTimeDate()));
                model.addPropertyChangeListener("timeDate", (PropertyChangeListener)new MutateOnConditionalPropertyChangeListener((ModelToBean)model, mutator, predicate));
            }
            if (model.getPropertyDate() != null) {
                mutator = BeanUtil.getMutator((Object)bean, (String)model.getPropertyDate());
                Preconditions.checkNotNull((Object)mutator, (Object)("could not find mutator for " + model.getPropertyDate()));
                model.addPropertyChangeListener("date", (PropertyChangeListener)new MutateOnConditionalPropertyChangeListener((ModelToBean)model, mutator, predicate));
            }
        }
    }

    public Date getMinuteModelValue(Date incomingDate) {
        if (incomingDate == null) {
            incomingDate = new Date();
        }
        this.calendarMinute.setTime(incomingDate);
        this.calendarMinute.set(11, 0);
        incomingDate = this.calendarMinute.getTime();
        return incomingDate;
    }

    public Date getHourModelValue(Date incomingDate) {
        if (incomingDate == null) {
            incomingDate = new Date();
        }
        this.calendarHour.setTime(incomingDate);
        this.calendarHour.set(12, 0);
        incomingDate = this.calendarHour.getTime();
        return incomingDate;
    }

    public void setHours(Date hourDate) {
        DateTimeEditorModel model = this.ui.getModel();
        Date oldTimeDate = model.getTimeDate();
        if (oldTimeDate == null) {
            return;
        }
        this.calendarHour.setTime(hourDate);
        int newHour = this.calendarHour.get(11);
        int newMinute = this.calendarHour.get(12);
        int oldHour = model.getHour(oldTimeDate);
        int oldMinute = model.getMinute(oldTimeDate);
        if (oldHour == newHour && oldMinute == newMinute) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Do not update time model , stay on same time = " + oldHour + ":" + oldMinute));
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("hh:mm (old from dateModel)   = " + oldHour + ":" + oldMinute));
            log.debug((Object)("hh:mm (new from hourModel) = " + newHour + ":" + newMinute));
        }
        Integer dayAdjust = null;
        if (newHour == 0 && oldHour == 23) {
            dayAdjust = 1;
        } else if (newHour == 23 && oldHour == 0) {
            dayAdjust = -1;
        }
        if (dayAdjust != null) {
            Date oldDayDate = model.getDayDate();
            this.calendarHour.setTime(oldDayDate);
            this.calendarHour.add(6, dayAdjust);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Update day to " + this.calendarHour.get(6)));
            }
            Date newDayDate = this.calendarHour.getTime();
            model.setDayDate(newDayDate);
        }
        model.setTimeInMinutes(newHour * 60 + oldMinute);
    }

    public void setMinutes(Date minuteDate) {
        DateTimeEditorModel model = this.ui.getModel();
        Date oldTimeDate = model.getTimeDate();
        if (oldTimeDate == null) {
            return;
        }
        this.calendarMinute.setTime(minuteDate);
        int newHour = this.calendarMinute.get(11);
        int newMinute = this.calendarMinute.get(12);
        int oldHour = model.getHour(oldTimeDate);
        int oldMinute = model.getMinute(oldTimeDate);
        if (oldHour == newHour && oldMinute == newMinute) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Do not update time model , stay on same time = " + oldHour + ":" + oldMinute));
            }
            return;
        }
        int hour = oldHour;
        if (log.isDebugEnabled()) {
            log.debug((Object)("hh:mm (old from dateModel)   = " + oldHour + ":" + oldMinute));
            log.debug((Object)("hh:mm (new from minuteModel) = " + newHour + ":" + newMinute));
        }
        Integer dayAdjust = null;
        if (newMinute == 0) {
            if (newHour == 1) {
                if (oldHour == 23) {
                    dayAdjust = 1;
                }
                hour = (oldHour + 1) % 24;
            }
        } else if (newMinute == 59 && newHour == 23) {
            if (oldHour == 0) {
                dayAdjust = -1;
            }
            hour = (oldHour - 1) % 24;
        }
        if (dayAdjust != null) {
            Date oldDayDate = model.getDayDate();
            this.calendarHour.setTime(oldDayDate);
            this.calendarHour.add(6, dayAdjust);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Update day to " + this.calendarHour.get(6)));
            }
            Date newDayDate = this.calendarHour.getTime();
            model.setDayDate(newDayDate);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Update time model to hh:mm = " + hour + ":" + newMinute));
        }
        model.setTimeInMinutes(hour * 60 + newMinute);
    }
}

