/*
 * #%L
 * JAXX :: Tutorial Validation
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.demo.validation.ui;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import jaxx.demo.validation.DemoConfig;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.CardLayout2;
import jaxx.runtime.swing.StatusMessagePanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class DemoUI extends JFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_MAIN_FRAME_UNDECORATED = "mainFrame.undecorated";
    public static final String BINDING_MENU_FILE_FULLSCREEN_VISIBLE = "menuFileFullscreen.visible";
    public static final String BINDING_MENU_FILE_LANGUAGE_FR_ENABLED = "menuFileLanguageFR.enabled";
    public static final String BINDING_MENU_FILE_LANGUAGE_UK_ENABLED = "menuFileLanguageUK.enabled";
    public static final String BINDING_MENU_FILE_NORMALSCREEN_VISIBLE = "menuFileNormalscreen.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(DemoUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected DemoConfig config;
    protected CardLayout2 contentLayout;
    protected DemoUIHandler handler;
    protected DemoUI mainFrame = this;
    protected JPanel mainPane;
    protected JMenuBar menu;
    protected JMenu menuFile;
    protected JMenuItem menuFileConfiguration;
    protected JMenuItem menuFileExit;
    protected JMenuItem menuFileFullscreen;
    protected JMenu menuFileLanguage;
    protected JMenuItem menuFileLanguageFR;
    protected JMenuItem menuFileLanguageUK;
    protected JMenuItem menuFileNormalscreen;
    protected JMenu menuHelp;
    protected JMenuItem menuHelpAbout;
    protected JMenuItem menuHelpHelp;
    protected JMenuItem menuHelpSite;
    protected StatusMessagePanel p;
    protected ValidationTableDemo tableDemo;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSeparator $JSeparator0;
    private JSeparator $JSeparator1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    public boolean acceptLocale(Locale l, String expected) {
      return l !=null && l.toString().equals(expected);
    }
    
    private void $afterCompleteSetup() {
        getHandler().initUI(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DemoUI() {
        $initialize();
    }

    public DemoUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemoUI(GraphicsConfiguration param0) {
        super(param0);
        $initialize();
    }

    public DemoUI(JAXXContext parentContext, GraphicsConfiguration param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemoUI(String param0) {
        super(param0);
        $initialize();
    }

    public DemoUI(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemoUI(String param0, GraphicsConfiguration param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemoUI(JAXXContext parentContext, String param1, GraphicsConfiguration param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__menuFileConfiguration(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showConfig(this);
    }

    public void doActionPerformed__on__menuFileExit(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().close(this);
    }

    public void doActionPerformed__on__menuFileFullscreen(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().changeScreen(this, true);
    }

    public void doActionPerformed__on__menuFileLanguageFR(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().changeLanguage(this, Locale.FRANCE);
    }

    public void doActionPerformed__on__menuFileLanguageUK(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().changeLanguage(this, Locale.UK);
    }

    public void doActionPerformed__on__menuFileNormalscreen(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().changeScreen(this, false);
    }

    public void doActionPerformed__on__menuHelpAbout(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showAbout(this);
    }

    public void doActionPerformed__on__menuHelpHelp(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().showHelp(this, null);
    }

    public void doActionPerformed__on__menuHelpSite(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().gotoSite(this);
    }

    public void doWindowClosing__on__mainFrame(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getHandler().close(mainFrame);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public DemoConfig getConfig() {
        return config;
    }

    public CardLayout2 getContentLayout() {
        return contentLayout;
    }

    public DemoUIHandler getHandler() {
        return handler;
    }

    public JPanel getMainPane() {
        return mainPane;
    }

    public JMenuBar getMenu() {
        return menu;
    }

    public JMenu getMenuFile() {
        return menuFile;
    }

    public JMenuItem getMenuFileConfiguration() {
        return menuFileConfiguration;
    }

    public JMenuItem getMenuFileExit() {
        return menuFileExit;
    }

    public JMenuItem getMenuFileFullscreen() {
        return menuFileFullscreen;
    }

    public JMenu getMenuFileLanguage() {
        return menuFileLanguage;
    }

    public JMenuItem getMenuFileLanguageFR() {
        return menuFileLanguageFR;
    }

    public JMenuItem getMenuFileLanguageUK() {
        return menuFileLanguageUK;
    }

    public JMenuItem getMenuFileNormalscreen() {
        return menuFileNormalscreen;
    }

    public JMenu getMenuHelp() {
        return menuHelp;
    }

    public JMenuItem getMenuHelpAbout() {
        return menuHelpAbout;
    }

    public JMenuItem getMenuHelpHelp() {
        return menuHelpHelp;
    }

    public JMenuItem getMenuHelpSite() {
        return menuHelpSite;
    }

    public StatusMessagePanel getP() {
        return p;
    }

    public ValidationTableDemo getTableDemo() {
        return tableDemo;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToMainFrame() {
        if (!allComponentsCreated) {
            return;
        }
        add(mainPane);
        mainFrame.setJMenuBar(menu);
    }

    protected void addChildrenToMainPane() {
        if (!allComponentsCreated) {
            return;
        }
        mainPane.add(tableDemo, BorderLayout.CENTER);
        mainPane.add(p, BorderLayout.SOUTH);
    }

    protected void addChildrenToMenu() {
        if (!allComponentsCreated) {
            return;
        }
        menu.add(menuFile);
        menu.add(menuHelp);
    }

    protected void addChildrenToMenuFile() {
        if (!allComponentsCreated) {
            return;
        }
        menuFile.add(menuFileConfiguration);
        menuFile.add(menuFileLanguage);
        menuFile.add($JSeparator0);
        menuFile.add(menuFileFullscreen);
        menuFile.add(menuFileNormalscreen);
        menuFile.add($JSeparator1);
        menuFile.add(menuFileExit);
    }

    protected void addChildrenToMenuFileLanguage() {
        if (!allComponentsCreated) {
            return;
        }
        menuFileLanguage.add(menuFileLanguageFR);
        menuFileLanguage.add(menuFileLanguageUK);
    }

    protected void addChildrenToMenuHelp() {
        if (!allComponentsCreated) {
            return;
        }
        menuHelp.add(menuHelpHelp);
        menuHelp.add(menuHelpSite);
        menuHelp.add(menuHelpAbout);
    }

    protected void createConfig() {
        $objectMap.put("config", config = getContextValue(DemoConfig.class));
    }

    protected void createContentLayout() {
        $objectMap.put("contentLayout", contentLayout = new CardLayout2());
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(DemoUIHandler.class));
    }

    protected void createMainPane() {
        $objectMap.put("mainPane", mainPane = new JPanel());
        
        mainPane.setName("mainPane");
        mainPane.setLayout(new BorderLayout());
    }

    protected void createMenu() {
        $objectMap.put("menu", menu = new JMenuBar());
        
        menu.setName("menu");
        menu.putClientProperty("help", "ui.main.menu");
    }

    protected void createMenuFile() {
        $objectMap.put("menuFile", menuFile = new JMenu());
        
        menuFile.setName("menuFile");
        menuFile.setText(_("jaxxdemo.menu.file"));
        menuFile.setMnemonic(70);
        menuFile.putClientProperty("help", "ui.main.menu.file");
    }

    protected void createMenuFileConfiguration() {
        $objectMap.put("menuFileConfiguration", menuFileConfiguration = new JMenuItem());
        
        menuFileConfiguration.setName("menuFileConfiguration");
        menuFileConfiguration.setText(_("jaxxdemo.action.configuration"));
        menuFileConfiguration.setMnemonic(67);
        menuFileConfiguration.setToolTipText(_("jaxxdemo.action.configuration.tip"));
        menuFileConfiguration.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileConfiguration"));
        menuFileConfiguration.putClientProperty("help", "ui.main.menu.file.configuration");
    }

    protected void createMenuFileExit() {
        $objectMap.put("menuFileExit", menuFileExit = new JMenuItem());
        
        menuFileExit.setName("menuFileExit");
        menuFileExit.setText(_("jaxxdemo.action.exit"));
        menuFileExit.setMnemonic(88);
        menuFileExit.setToolTipText(_("jaxxdemo.action.exit.tip"));
        menuFileExit.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileExit"));
        menuFileExit.putClientProperty("help", "ui.main.menu.file.exit");
    }

    protected void createMenuFileFullscreen() {
        $objectMap.put("menuFileFullscreen", menuFileFullscreen = new JMenuItem());
        
        menuFileFullscreen.setName("menuFileFullscreen");
        menuFileFullscreen.setText(_("jaxxdemo.action.fullscreen"));
        menuFileFullscreen.setMnemonic(80);
        menuFileFullscreen.setToolTipText(_("jaxxdemo.action.fullscreen.tip"));
        menuFileFullscreen.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileFullscreen"));
        menuFileFullscreen.putClientProperty("help", "ui.main.menu.file.fullscreen");
    }

    protected void createMenuFileLanguage() {
        $objectMap.put("menuFileLanguage", menuFileLanguage = new JMenu());
        
        menuFileLanguage.setName("menuFileLanguage");
        menuFileLanguage.setText(_("jaxxdemo.menu.file.locale"));
        menuFileLanguage.setMnemonic(67);
        menuFileLanguage.setToolTipText(_("jaxxdemo.menu.file.locale"));
        menuFileLanguage.putClientProperty("help", "ui.main.menu.file.locale");
    }

    protected void createMenuFileLanguageFR() {
        $objectMap.put("menuFileLanguageFR", menuFileLanguageFR = new JMenuItem());
        
        menuFileLanguageFR.setName("menuFileLanguageFR");
        menuFileLanguageFR.setText(_("jaxxdemo.action.locale.fr"));
        menuFileLanguageFR.setMnemonic(70);
        menuFileLanguageFR.setToolTipText(_("jaxxdemo.action.locale.fr.tip"));
        menuFileLanguageFR.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileLanguageFR"));
        menuFileLanguageFR.putClientProperty("help", "ui.main.menu.file.locale.fr");
    }

    protected void createMenuFileLanguageUK() {
        $objectMap.put("menuFileLanguageUK", menuFileLanguageUK = new JMenuItem());
        
        menuFileLanguageUK.setName("menuFileLanguageUK");
        menuFileLanguageUK.setText(_("jaxxdemo.action.locale.uk"));
        menuFileLanguageUK.setMnemonic(85);
        menuFileLanguageUK.setToolTipText(_("jaxxdemo.action.locale.uk.tip"));
        menuFileLanguageUK.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileLanguageUK"));
        menuFileLanguageUK.putClientProperty("help", "ui.main.menu.file.locale.uk");
    }

    protected void createMenuFileNormalscreen() {
        $objectMap.put("menuFileNormalscreen", menuFileNormalscreen = new JMenuItem());
        
        menuFileNormalscreen.setName("menuFileNormalscreen");
        menuFileNormalscreen.setText(_("jaxxdemo.action.normalscreen"));
        menuFileNormalscreen.setMnemonic(78);
        menuFileNormalscreen.setToolTipText(_("jaxxdemo.action.normalscreen.tip"));
        menuFileNormalscreen.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuFileNormalscreen"));
        menuFileNormalscreen.putClientProperty("help", "ui.main.menu.file.leave-fullscreen");
    }

    protected void createMenuHelp() {
        $objectMap.put("menuHelp", menuHelp = new JMenu());
        
        menuHelp.setName("menuHelp");
        menuHelp.setText(_("jaxxdemo.menu.help"));
        menuHelp.setMnemonic(101);
        menuHelp.putClientProperty("help", "ui.main.menu.help");
    }

    protected void createMenuHelpAbout() {
        $objectMap.put("menuHelpAbout", menuHelpAbout = new JMenuItem());
        
        menuHelpAbout.setName("menuHelpAbout");
        menuHelpAbout.setText(_("jaxxdemo.action.about"));
        menuHelpAbout.setMnemonic(65);
        menuHelpAbout.setToolTipText(_("jaxxdemo.action.about.tip"));
        menuHelpAbout.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpAbout"));
        menuHelpAbout.putClientProperty("help", "ui.main.menu.help.about");
    }

    protected void createMenuHelpHelp() {
        $objectMap.put("menuHelpHelp", menuHelpHelp = new JMenuItem());
        
        menuHelpHelp.setName("menuHelpHelp");
        menuHelpHelp.setText(_("jaxxdemo.action.help"));
        menuHelpHelp.setMnemonic(101);
        menuHelpHelp.setToolTipText(_("jaxxdemo.action.help.tip"));
        menuHelpHelp.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpHelp"));
        menuHelpHelp.putClientProperty("help", "ui.main.menu.help.help");
    }

    protected void createMenuHelpSite() {
        $objectMap.put("menuHelpSite", menuHelpSite = new JMenuItem());
        
        menuHelpSite.setName("menuHelpSite");
        menuHelpSite.setText(_("jaxxdemo.action.site"));
        menuHelpSite.setMnemonic(115);
        menuHelpSite.setToolTipText(_("jaxxdemo.action.site.tip"));
        menuHelpSite.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpSite"));
        menuHelpSite.putClientProperty("help", "ui.main.menu.help.site");
    }

    protected void createP() {
        $objectMap.put("p", p = new StatusMessagePanel());
        
        p.setName("p");
    }

    protected void createTableDemo() {
        $objectMap.put("tableDemo", tableDemo = new ValidationTableDemo());
        
        tableDemo.setName("tableDemo");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToMainFrame();
        addChildrenToMenu();
        addChildrenToMenuFile();
        addChildrenToMenuFileLanguage();
        addChildrenToMenuHelp();
        addChildrenToMainPane();
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 12 property setters
        setIconImage(jaxx.runtime.SwingUtil.createIcon(getConfig().getOption("application.icon.path")).getImage());
        menuFileConfiguration.setIcon(SwingUtil.createActionIcon("config"));
        menuFileLanguage.setIcon(SwingUtil.createActionIcon("translate"));
        menuFileLanguageFR.setIcon(SwingUtil.createActionIcon("i18n-fr"));
        menuFileLanguageUK.setIcon(SwingUtil.createActionIcon("i18n-uk"));
        menuFileFullscreen.setIcon(SwingUtil.createActionIcon("fullscreen"));
        menuFileNormalscreen.setIcon(SwingUtil.createActionIcon("leave-fullscreen"));
        menuFileExit.setIcon(SwingUtil.createActionIcon("exit"));
        menuHelpHelp.setIcon(SwingUtil.createActionIcon("help"));
        menuHelpSite.setIcon(SwingUtil.createActionIcon("site"));
        menuHelpAbout.setIcon(SwingUtil.createActionIcon("about"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("mainFrame", mainFrame);
        createContentLayout();
        createConfig();
        createHandler();
        createMenu();
        createMenuFile();
        createMenuFileConfiguration();
        createMenuFileLanguage();
        createMenuFileLanguageFR();
        createMenuFileLanguageUK();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createMenuFileFullscreen();
        createMenuFileNormalscreen();
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new JSeparator());
        
        $JSeparator1.setName("$JSeparator1");
        createMenuFileExit();
        createMenuHelp();
        createMenuHelpHelp();
        createMenuHelpSite();
        createMenuHelpAbout();
        createMainPane();
        createTableDemo();
        createP();
        // inline creation of mainFrame
        setName("mainFrame");
        SwingUtil.setComponentHeight(mainFrame,800);
        SwingUtil.setComponentWidth(mainFrame,1024);
        setTitle(_("JAXX Demo"));
        mainFrame.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__mainFrame"));
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MAIN_FRAME_UNDECORATED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("fullScreen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    setUndecorated(getConfig().isFullScreen());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("fullScreen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_LANGUAGE_FR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    menuFileLanguageFR.setEnabled(!acceptLocale(getConfig().getLocale(), "fr_FR"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("locale", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_LANGUAGE_UK_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (getConfig() != null) {
                    getConfig().addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getConfig() != null) {
                    menuFileLanguageUK.setEnabled(!acceptLocale(getConfig().getLocale(), "en_GB"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (getConfig() != null) {
                    getConfig().removePropertyChangeListener("locale", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MENU_FILE_FULLSCREEN_VISIBLE, true ,"undecorated") {
        
            @Override
            public void processDataBinding() {
                menuFileFullscreen.setVisible(!isUndecorated());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MENU_FILE_NORMALSCREEN_VISIBLE, true ,"undecorated") {
        
            @Override
            public void processDataBinding() {
                menuFileNormalscreen.setVisible(isUndecorated());
            }
        });
    }

}