package org.nuiton.jaxx.swing.extra;

import org.nuiton.jaxx.swing.extra.list.JaxxDefaultListModel;

import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import java.util.Collection;

/**
 * Created on 4/6/15.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 3.0
 */
public class JLists {

    /**
     * Fill a list model with some datas, and select after all the given object
     *
     * @param list   the list to fill
     * @param data   data ot inject in combo
     * @param select the object to select in combo after reflling his model
     */
    public static void fillList(JList list, Collection<?> data, Object select) {
        ListModel listModel = list.getModel();
        if (listModel instanceof JaxxDefaultListModel) {
            JaxxDefaultListModel model = (JaxxDefaultListModel) listModel;

            // evince the model
//        model.removeListDataListener(combo);
            model.setAllElements(data);

            // attach the model
//        model.addListDataListener(combo);
            list.setSelectedValue(select, true);
        } else if (listModel instanceof DefaultListModel) {
            DefaultListModel model = (DefaultListModel) listModel;
            // evince the model
//        model.removeListDataListener(combo);
            model.removeAllElements();
            if (data != null) {
                for (Object o : data) {
                    model.addElement(o);
                }
            }
            // attach the model
//        model.addListDataListener(combo);
            list.setSelectedValue(select, true);
        } else {
            throw new IllegalArgumentException(
                    "this method need a DefaultListModel for this model " +
                    "but was " + listModel.getClass());
        }
    }
}
