/**
 * ##% Copyright (C) 2008 Code Lutin, Tony Chemit
 * This program is free software; you
 * can redistribute it and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. This program is
 * distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU General Public License for more details. You
 * should have received a copy of the GNU General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 59 Temple Place
 * - Suite 330, Boston, MA 02111-1307, USA. 
 * ##%
 */
package org.nuiton.jaxx.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @param <H> type of handler
 * @author chemit */
public abstract class AbstractUIAction<H extends DialogUIHandler<?, ?>> extends javax.swing.AbstractAction {

    protected static Log log = LogFactory.getLog(AbstractUIAction.class);

    protected transient DialogUI<? extends H> ui;

    private static final long serialVersionUID = 1L;

    protected AbstractUIAction(String name, javax.swing.Icon icon, DialogUI<? extends H> ui) {
        super(name, icon);
        this.ui = ui;
    }

    protected H getHandler() {
        checkInit();
        return ui.getHandler();
    }

    protected void setUi(DialogUI<? extends H> ui) {
        this.ui = ui;
    }

    public DialogUI<? extends H> getUi() {
        return ui;
    }

    protected void checkInit() throws IllegalStateException {
        /*if (ui == null) {
            throw new IllegalStateException("no handler, nor ui referenced in " + this);
        } */
    }

}
