/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.swing.renderer;

import com.google.common.base.Predicate;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class BooleanCellRenderer
extends JPanel
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    protected final TableCellRenderer defaultDelegate;
    protected final JCheckBox checkBox;
    private final Predicate predicate;
    private static final Predicate<Object> DEFAULT_PREDICATE = input -> input != null && (Boolean)input != false;

    public BooleanCellRenderer(TableCellRenderer delegate, Predicate<?> predicate) {
        this(delegate, new JCheckBox(), predicate);
    }

    public BooleanCellRenderer(TableCellRenderer delegate) {
        this(delegate, DEFAULT_PREDICATE);
    }

    public BooleanCellRenderer(TableCellRenderer delegate, Icon icon, Predicate<?> predicate) {
        this(delegate, new JCheckBox(icon), predicate);
    }

    public BooleanCellRenderer(TableCellRenderer delegate, Icon icon) {
        this(delegate, icon, DEFAULT_PREDICATE);
        this.checkBox.setVerticalTextPosition(1);
    }

    public BooleanCellRenderer(TableCellRenderer delegate, JCheckBox checkBox, Predicate<?> predicate) {
        this.defaultDelegate = delegate;
        this.predicate = predicate;
        this.checkBox = checkBox;
        this.checkBox.setBorderPainted(true);
        this.checkBox.setHorizontalAlignment(0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ((JComponent)((Object)this.defaultDelegate)).setBackground(null);
        JComponent render = (JComponent)this.defaultDelegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(render.getForeground());
            this.setBackground(render.getBackground());
            if (row % 2 == 1) {
                this.setBackground(Color.WHITE);
            }
        }
        boolean selectCheckBox = this.predicate.apply(value);
        this.checkBox.setSelected(selectCheckBox);
        this.setBorder(render.getBorder());
        return this.checkBox;
    }
}

