/*
 * #%L
 * JAXX :: Runtime
 * 
 * $Id: DecoratorListCellRenderer.java 2727 2013-09-30 15:38:09Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.29/jaxx-runtime/src/main/java/jaxx/runtime/swing/renderer/DecoratorListCellRenderer.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing.renderer;

import org.nuiton.decorator.Decorator;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import java.awt.Component;

/**
 * A {@link ListCellRenderer} which compute text with the given {@link #decorator}
 * and leave the hand to the {@link #delegate} to perform the visual renderer.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.7.2
 */
public class DecoratorListCellRenderer implements ListCellRenderer {

    /** Delegate cell renderer */
    protected ListCellRenderer delegate;

    /** Decorator to produce text to render */
    protected Decorator<?> decorator;

    public DecoratorListCellRenderer(Decorator<?> decorator) {
        this(new DefaultListCellRenderer(), decorator);
    }

    public DecoratorListCellRenderer(ListCellRenderer delegate,
                                     Decorator<?> decorator) {
        this.delegate = delegate;
        this.decorator = decorator;
    }

    @Override
    public Component getListCellRendererComponent(JList list,
                                                  Object value,
                                                  int index,
                                                  boolean isSelected,
                                                  boolean cellHasFocus) {
        value = decorateValue(value, index);
        return delegate.getListCellRendererComponent(list,
                                                     value,
                                                     index,
                                                     isSelected,
                                                     cellHasFocus
        );
    }

    protected Object decorateValue(Object value,int index) {
        if (value == null) {
            value = " ";
        }
        if (!(value instanceof String) && decorator != null) {
            value = decorator.toString(value);
        }
        return value;
    }
}
