/*
 * #%L
 * JAXX :: Runtime
 * 
 * $Id: Application.java 2225 2011-02-19 20:15:00Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.5.27/jaxx-runtime/src/main/java/jaxx/runtime/swing/Application.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.swing;

import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import java.awt.GraphicsConfiguration;

public class Application extends JFrame {

    private static final long serialVersionUID = 1L;
    // Special: jaxxc will automatically add a main() method to any components which
    // extend <Application>

    public Application() {
    }

    public Application(GraphicsConfiguration gc) {
        super(gc);
    }

    public Application(String title) {
        super(title);
    }

    public Application(String title, GraphicsConfiguration gc) {
        super(title, gc);
    }

    public void setLookAndFeel(String lookAndFeel) {
        if (lookAndFeel.equals("system")) {
            lookAndFeel = UIManager.getSystemLookAndFeelClassName();
        } else if (lookAndFeel.equals("cross_platform")) {
            lookAndFeel = UIManager.getCrossPlatformLookAndFeelClassName();
        }
        try {
            UIManager.setLookAndFeel(lookAndFeel);
            if (isDisplayable()) {
                SwingUtilities.updateComponentTreeUI(this);
            }
        } catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        } catch (InstantiationException e) {
            throw new RuntimeException(e);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        } catch (UnsupportedLookAndFeelException e) {
            throw new RuntimeException(e);
        }
    }
}
