/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.navigation;

import javax.swing.JTree;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.swing.navigation.NavigationTreeHandler;
import jaxx.runtime.swing.navigation.NavigationTreeModel;
import jaxx.runtime.swing.navigation.NavigationTreeNode;

public class NavigationTreeContextHelper {
    protected final String prefix;
    protected JAXXContextEntryDef<String> selectedPathContextEntry;
    protected JAXXContextEntryDef<Object> selectedBeanContextEntry;
    protected JAXXContextEntryDef<NavigationTreeNode> selectedNodeContextEntry;
    protected JAXXContextEntryDef<NavigationTreeModel> treeModelContextEntry;
    protected JAXXContextEntryDef<NavigationTreeHandler> treeHandlerContextEntry;
    protected JAXXContextEntryDef<JTree> treeContextEntry;

    public NavigationTreeContextHelper(String prefix) {
        this.prefix = prefix;
        this.treeContextEntry = JAXXUtil.newContextEntryDef(prefix + "-tree", JTree.class);
        this.treeModelContextEntry = JAXXUtil.newContextEntryDef(prefix + "-tree-model", NavigationTreeModel.class);
        this.treeHandlerContextEntry = JAXXUtil.newContextEntryDef(prefix + "-tree-handler", NavigationTreeHandler.class);
        this.selectedBeanContextEntry = JAXXUtil.newContextEntryDef(prefix + "-selected-bean", Object.class);
        this.selectedNodeContextEntry = JAXXUtil.newContextEntryDef(prefix + "-selected-node", NavigationTreeNode.class);
        this.selectedPathContextEntry = JAXXUtil.newContextEntryDef(prefix + "-selected-path", String.class);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public JTree getTree(JAXXContext context) {
        JTree r = this.getTreeContextEntry().getContextValue(context);
        return r;
    }

    public NavigationTreeModel getTreeModel(JAXXContext context) {
        NavigationTreeModel r = this.getTreeModelContextEntry().getContextValue(context);
        return r;
    }

    public NavigationTreeHandler getTreeHandler(JAXXContext context) {
        NavigationTreeHandler r = this.getTreeHandlerContextEntry().getContextValue(context);
        return r;
    }

    public String getSelectedPath(JAXXContext context) {
        String r = this.getSelectedPathContextEntry().getContextValue(context);
        return r;
    }

    public NavigationTreeNode getSelectedNode(JAXXContext context) {
        NavigationTreeNode r = this.getSelectedNodeContextEntry().getContextValue(context);
        return r;
    }

    public Object getSelectedBean(JAXXContext context) {
        Object r = this.getSelectedBeanContextEntry().getContextValue(context);
        return r;
    }

    public void setTreeModel(JAXXContext context, NavigationTreeModel model) {
        this.getTreeModelContextEntry().setContextValue(context, model);
    }

    public void setTree(JAXXContext context, JTree tree) {
        this.getTreeContextEntry().setContextValue(context, tree);
    }

    public void setTreeHandler(JAXXContext context, NavigationTreeHandler handler) {
        this.getTreeHandlerContextEntry().setContextValue(context, handler);
    }

    public void setSelectedPath(JAXXContext context, String path) {
        if (path == null) {
            this.getSelectedPathContextEntry().removeContextValue(context);
        } else {
            this.getSelectedPathContextEntry().setContextValue(context, path);
        }
    }

    public void setSelectedNode(JAXXContext context, NavigationTreeNode node) {
        if (node == null) {
            this.getSelectedNodeContextEntry().removeContextValue(context);
        } else {
            this.getSelectedNodeContextEntry().setContextValue(context, node);
        }
    }

    public void setSelectedBean(JAXXContext context, Object bean) {
        if (bean == null) {
            this.getSelectedBeanContextEntry().removeContextValue(context);
        } else {
            this.getSelectedBeanContextEntry().setContextValue(context, bean);
        }
    }

    protected JAXXContextEntryDef<NavigationTreeModel> getTreeModelContextEntry() {
        return this.treeModelContextEntry;
    }

    protected JAXXContextEntryDef<NavigationTreeHandler> getTreeHandlerContextEntry() {
        return this.treeHandlerContextEntry;
    }

    protected JAXXContextEntryDef<Object> getSelectedBeanContextEntry() {
        return this.selectedBeanContextEntry;
    }

    protected JAXXContextEntryDef<NavigationTreeNode> getSelectedNodeContextEntry() {
        return this.selectedNodeContextEntry;
    }

    protected JAXXContextEntryDef<String> getSelectedPathContextEntry() {
        return this.selectedPathContextEntry;
    }

    protected JAXXContextEntryDef<JTree> getTreeContextEntry() {
        return this.treeContextEntry;
    }
}

