package jaxx.runtime.swing.editor;

import jaxx.runtime.swing.editor.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import javax.swing.table.TableColumn;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.swing.I18nTableCellRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ColumnSelector extends javax.swing.JPanel implements PropertyChangeListener,  ActionListener, jaxx.runtime.JAXXObject {
    public static final Log log = LogFactory.getLog(jaxx.runtime.swing.editor.ColumnSelector.class);
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz08TQRSeVvqTnwKSGDGgEmNM3KIXEyCogESaokSIIfbitDuUIdOdYWYWFg/GxKsxnDx4Ue8evRvj0ZNX/wdj/A98M9t2W6y0gR52m7ff+9733nxvPv1CCSXRpR0cBI70PU2rxMnf29x8VNohZb1EVFlSoblE4S8WR/Ei6nUbcaXRlWLBpOdq6blFXhXcI15T9mwBZZU+YERtE6I1OhdmlJXKrTfCs4HwZZ2tIaYd24c/v+OH7suPcYQCAarS0MJkp6yog54CilNXo2GotIdzDHsVkCGpVwGd/Sa2yLBSD3GV7KIXKFVASYElkGl0uftWLYfND4RG6an8GvYIm9boWotStQ91HeJSyAXZzK9664TB7LkUwuYnNUpVDzZwiRGNhow8x0h2wiOKQH2CC188oYpa5NkIucA5I9iLoAkL1WjMYIKahvyaCa4Sz4+AWQss4BJhMK8WtA0a2HADPTK1bqew4lFNMaPPibyp0YTttwyjooxI5x9IU7Wp/AZIXcDylkajLdVqcQPMNPDJkq819zQ6fwRbqTCyYL8Z5AUB/hgJVSjlRI6LLBErooT0IQwTLkbmfAyh0Ja1qCWw0fev3u29/fxlpu7BAajR3wJpWhnwhJBcEKmpKTEYGs/XlOVWsZgtooyqnTl8HW0SULcCiAD+8EhNmvMAq21ITaR+fv029uzHGRRfRlnGsbuMDX4FZfS2hC45cwNx565V0refhueQ0QSzY/iAw4jQwJyLNZ4sUc+F6c0H0OxoU7MNBd8PX6+Ov7l4u95wLBR0BBY1nXiKktRj1CN23Wqb1Ha9eoUivsujjWm3QzHzzoqaW67a5/W2nZW4dIm1yo3ANy/HyjX/pi3LSBcsKeKZjTPXxFzYxiTWcEmA5ch8e9qxLmh7NAm0+Tpzco7+sME1TD1N3GPIxrsgy2yBa7Rp9ZRESS7wrn9alh5aDpf2P0c30ZHDhJeOUdGZAa7SLV72VecBd8OVsVwdBtwN0aDkjPE9Iu+HzjwlXTq8ckKeE09bo14NV/MGFRvHG9tQ/QUnIDn8bggAAA==";
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected javax.swing.JToggleButton button;
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.DefaultJAXXContext(this);;
    protected java.lang.Object myTable;
    protected javax.swing.JPopupMenu popup;
    protected javax.swing.JLabel popupLabel;
    protected java.lang.Boolean popupVisible;
    private jaxx.runtime.swing.editor.ColumnSelector $JPanel0 = this;
    private javax.swing.JToolBar $JToolBar2;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource6 = new jaxx.runtime.DataBindingListener($JPanel0, "button.selected");

    /* begin raw body code */
    public static final String TABLE_PROPERTY = "myTable";
    public static final String POPUP_VISIBLE_PROPERTY = "popupVisible";
    
    
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (log.isDebugEnabled()) {
            log.debug(name+" <old:"+evt.getOldValue()+" - new:"+evt.getNewValue()+">");
        }
        //log.info(name+" <old:"+evt.getOldValue()+" - new:"+evt.getNewValue()+">");
        if (TABLE_PROPERTY.equals(name)) {
            // table has changed, rebuild the popup
            try {
                
                popup.removeAll();
                JTable t = (JTable) evt.getNewValue();
                if (t != null) {
                    log.info("table has changed ! " + t.getName());
                    for (int i = 0, columnCount = t.getColumnCount(); i < columnCount; i++) {
                        TableColumn column = t.getColumnModel().getColumn(i);
                        TableCellRenderer defaultRenderer = t.getTableHeader().getDefaultRenderer();
                        String columnName = column.getHeaderValue() + "";
                        if (defaultRenderer instanceof I18nTableCellRenderer) {
                            I18nTableCellRenderer renderer = (I18nTableCellRenderer) defaultRenderer;
                            columnName = _(renderer.getKeys()[i]);
                        }
                        JRadioButtonMenuItem b = new JRadioButtonMenuItem(columnName, null, true);
                        popup.add(b);
                        b.addActionListener(this);
                        b.putClientProperty("columnIndex", i);
                        b.putClientProperty("columnName", columnName);
                        b.putClientProperty("column", column);
                    }
                }
            } finally {
                popup.invalidate();
            }
            return;
        }
        if (POPUP_VISIBLE_PROPERTY.equals(name)) {
            Boolean newValue = (Boolean) evt.getNewValue();
            if (newValue == null || !newValue) {
                if (getPopup() != null && getPopup().isVisible()) {
                    getPopup().setVisible(false);
                }
                return;
            }
            if (!getPopup().isVisible()) {
                SwingUtilities.invokeLater(showPopupRunnable);
            }
            return;
        }
        
    }
    
    @Override
    public void actionPerformed(ActionEvent event) {
        JRadioButtonMenuItem source = (JRadioButtonMenuItem) event.getSource();
        boolean selected = source.isSelected();
        TableColumn column = (TableColumn) source.getClientProperty("column");
        Integer columnIndex = (Integer) source.getClientProperty("columnIndex");
        String columnName = (String) source.getClientProperty("columnName");
        log.info(columnName + ", selected : " + selected);
        JTable t = (JTable) myTable;
        if (selected) {
            // reinject the column in table
            t.getColumnModel().addColumn(column);
        } else {
            // remove column from table
            t.getColumnModel().removeColumn(column);
        }
    }protected Runnable showPopupRunnable;
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public ColumnSelector() {
        $initialize();
    }

    public ColumnSelector(jaxx.runtime.JAXXContext parentContext) {
        if (parentContext instanceof jaxx.runtime.JAXXInitialContext) {
            ((jaxx.runtime.JAXXInitialContext)parentContext).to(this);
        } else {
            setContextValue(parentContext);
        }
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("button.selected".equals($binding)) {
            if (popup != null) {
                $bindingSources.put("popup", popup);
        popup.addComponentListener((java.awt.event.ComponentListener) jaxx.runtime.Util.getEventListener(java.awt.event.ComponentListener.class, $JPanel0, "$pr$u0"));
            }
        }
        processDataBinding($binding);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("button.selected".equals($dest)) {
            if (popup != null) {
                button.setSelected((popup.isVisible()));
            }
            }} finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("button.selected".equals($binding)) {
            if (popup != null) {
                ((javax.swing.JPopupMenu) $bindingSources.remove("popup")).removeComponentListener((java.awt.event.ComponentListener) jaxx.runtime.Util.getEventListener(java.awt.event.ComponentListener.class, $JPanel0, "$pr$u0"));
            }
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return delegateContext.getParentContainer(clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return delegateContext.getParentContainer(source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doFocusGained__on__$JPanel0(java.awt.event.FocusEvent event) {
        button.requestFocus();
    }

    public void doFocusLost__on__$JPanel0(java.awt.event.FocusEvent event) {
        setPopupVisible(false);
    }

    public void doItemStateChanged__on__button(java.awt.event.ItemEvent event) {
        if (event.getStateChange()  == ItemEvent.SELECTED) { setPopupVisible(true); } else { popupVisible = false; };
    }

    public void doPopupMenuCanceled__on__popup(javax.swing.event.PopupMenuEvent event) {
        button.setSelected(false);
    }

    public void doPopupMenuWillBecomeInvisible__on__popup(javax.swing.event.PopupMenuEvent event) {
        button.setSelected(false);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public javax.swing.JToggleButton getButton() {
        return button;
    }

    public java.lang.Object getMyTable() {
        return myTable;
    }

    public javax.swing.JPopupMenu getPopup() {
        return popup;
    }

    public javax.swing.JLabel getPopupLabel() {
        return popupLabel;
    }

    public java.lang.Boolean getPopupVisible() {
        return popupVisible;
    }

    public java.lang.Boolean isPopupVisible() {
        return popupVisible !=null && popupVisible;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setMyTable(java.lang.Object newValue) {
        java.lang.Object oldValue = this.myTable;
        this.myTable = newValue;
        firePropertyChange("myTable", oldValue, newValue);
    }

    public void setPopupVisible(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.popupVisible;
        this.popupVisible = newValue;
        firePropertyChange("popupVisible", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void $pr$u0(java.awt.event.ComponentEvent event) {
        $DataSource6.propertyChange(null);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected jaxx.runtime.swing.editor.ColumnSelector get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JToolBar get$JToolBar2() {
        return $JToolBar2;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    protected Log getLog() {
        return log;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        $JPanel0.add($JToolBar2);
        
        addChildrenToPopup();
        
        $JToolBar2.add(button, BorderLayout.CENTER);
        
        popup.setBorder((new TitledBorder(_("i18neditor.popup.title"))));
        button.setIcon((jaxx.runtime.Util.createActionIcon("numbereditor-calculator")));
        applyDataBinding("button.selected");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JPanel0", this);
        createMyTable();
        createPopupVisible();
        createPopup();
        createPopupLabel();
        create$ScriptInitializer1();
        
        $JToolBar2 = new javax.swing.JToolBar();
        $objectMap.put("$JToolBar2", $JToolBar2);
        $JToolBar2.setName("$JToolBar2");
        $JToolBar2.setBorderPainted(false);
        $JToolBar2.setFloatable(false);
        $JToolBar2.setOpaque(false);
        
        createButton();
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout((new BorderLayout()));
        $JPanel0.addFocusListener((java.awt.event.FocusListener) jaxx.runtime.Util.getEventListener(java.awt.event.FocusListener.class, "focusGained", $JPanel0, "doFocusGained__on__$JPanel0"));
        $JPanel0.addFocusListener((java.awt.event.FocusListener) jaxx.runtime.Util.getEventListener(java.awt.event.FocusListener.class, "focusLost", $JPanel0, "doFocusLost__on__$JPanel0"));
        
        
        addPropertyChangeListener(TABLE_PROPERTY,this);addPropertyChangeListener(POPUP_VISIBLE_PROPERTY,this);
        $completeSetup();
    }

    protected void addChildrenToPopup() {
        if (!allComponentsCreated) {
            return;
        }
        popup.add(popupLabel);
    }

    protected void create$ScriptInitializer1() {
        showPopupRunnable = new Runnable() {
            @Override
            public void run() {
                getPopup().pack();
                Dimension dim = getPopup().getPreferredSize();
                JToggleButton invoker = getButton();
                getPopup().show(invoker, (int) (invoker.getPreferredSize().getWidth() - dim.getWidth()), invoker.getHeight());
            }
        };
    }

    protected void createButton() {
        button = new javax.swing.JToggleButton();
        $objectMap.put("button", button);
        button.setName("button");
        button.setBorderPainted(false);
        button.setFocusPainted(false);
        button.setFocusable(true);
        button.setRolloverEnabled(false);
        button.setToolTipText(_("columnselector.action.tip"));
        button.addItemListener((java.awt.event.ItemListener) jaxx.runtime.Util.getEventListener(java.awt.event.ItemListener.class, "itemStateChanged", $JPanel0, "doItemStateChanged__on__button"));
    }

    protected void createMyTable() {
        myTable = null;
        $objectMap.put("myTable", myTable);
    }

    protected void createPopup() {
        popup = new javax.swing.JPopupMenu();
        $objectMap.put("popup", popup);
        popup.setName("popup");
        popup.addPopupMenuListener((javax.swing.event.PopupMenuListener) jaxx.runtime.Util.getEventListener(javax.swing.event.PopupMenuListener.class, "popupMenuCanceled", $JPanel0, "doPopupMenuCanceled__on__popup"));
        popup.addPopupMenuListener((javax.swing.event.PopupMenuListener) jaxx.runtime.Util.getEventListener(javax.swing.event.PopupMenuListener.class, "popupMenuWillBecomeInvisible", $JPanel0, "doPopupMenuWillBecomeInvisible__on__popup"));
    }

    protected void createPopupLabel() {
        popupLabel = new javax.swing.JLabel();
        $objectMap.put("popupLabel", popupLabel);
        popupLabel.setName("popupLabel");
        popupLabel.setEnabled(false);
        popupLabel.setText(_("i18neditor.empty.locales"));
    }

    protected void createPopupVisible() {
        popupVisible = false;
        $objectMap.put("popupVisible", popupVisible);
    }

}
