/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.api.internal;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class EventListeners {
    private static Map<Object, WeakReference<List<EventListenerDescriptor>>> eventListeners = new WeakHashMap<Object, WeakReference<List<EventListenerDescriptor>>>();

    public static <E extends EventListener> E getEventListener(Class<E> listenerClass, final String listenerMethodName, final Object methodContainer, String methodName) {
        ArrayList<EventListenerDescriptor> descriptors;
        WeakReference<List<EventListenerDescriptor>> ref = eventListeners.get(methodContainer);
        ArrayList<EventListenerDescriptor> arrayList = descriptors = ref != null ? (ArrayList<EventListenerDescriptor>)ref.get() : null;
        if (descriptors == null) {
            descriptors = new ArrayList<EventListenerDescriptor>();
            eventListeners.put(methodContainer, new WeakReference(descriptors));
        } else {
            for (EventListenerDescriptor descriptor : descriptors) {
                if (!descriptor.listenerClass.equals(listenerClass) || !(listenerMethodName == null ? descriptor.listenerMethodName == null : listenerMethodName.equals(descriptor.listenerMethodName)) || !methodName.equals(descriptor.methodName)) continue;
                return (E)((EventListener)descriptor.eventListener);
            }
        }
        final EventListenerDescriptor descriptor = new EventListenerDescriptor();
        descriptor.listenerClass = listenerClass;
        descriptor.listenerMethodName = listenerMethodName;
        descriptor.methodName = methodName;
        try {
            final List<Method> listenerMethods = Arrays.asList(listenerClass.getMethods());
            Method listenerMethod = null;
            if (listenerMethodName != null) {
                for (Method listenerMethod1 : listenerMethods) {
                    if (!listenerMethod1.getName().equals(listenerMethodName)) continue;
                    listenerMethod = listenerMethod1;
                    break;
                }
            }
            if (listenerMethodName != null && listenerMethod == null) {
                throw new IllegalArgumentException("no method named " + listenerMethodName + " found in class " + listenerClass.getName());
            }
            Class<?>[] parameterTypes = listenerMethodName != null ? listenerMethod.getParameterTypes() : listenerMethods.get(0).getParameterTypes();
            Class<?> methodContainerClass = methodContainer.getClass();
            final Method targetMethod = methodContainerClass.getMethod(methodName, parameterTypes);
            descriptor.eventListener = Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) {
                    String methodName = method.getName();
                    if (listenerMethodName == null && listenerMethods.contains(method) || methodName.equals(listenerMethodName)) {
                        try {
                            targetMethod.setAccessible(true);
                            return targetMethod.invoke(methodContainer, args);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException("could not invoke on container " + methodContainer, e);
                        }
                        catch (InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (methodName.equals("toString")) {
                        return this.toString();
                    }
                    if (methodName.equals("equals")) {
                        return descriptor.eventListener == args[0];
                    }
                    if (methodName.equals("hashCode")) {
                        return this.hashCode();
                    }
                    return null;
                }
            });
            descriptors.add(descriptor);
            return (E)((EventListener)descriptor.eventListener);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static <E extends EventListener> E getEventListener(Class<E> listenerClass, Object methodContainer, String methodName) {
        return EventListeners.getEventListener(listenerClass, null, methodContainer, methodName);
    }

    private static class EventListenerDescriptor {
        Class<?> listenerClass;
        String listenerMethodName;
        String methodName;
        Object eventListener;

        private EventListenerDescriptor() {
        }
    }
}

