package org.nuiton.jaxx.runtime.api.internal.descriptor;

import java.io.IOException;

/**
 * Created on 4/5/15.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 3.0
 */
public class JAXXObjectDescriptors {

    /**
     * Decodes the serialized representation of a JAXXObjectDescriptor.  The
     * string must be a byte-to-character mapping of the binary serialization
     * data for a JAXXObjectDescriptor.  See the comments in
     * JAXXCompiler.createJAXXObjectDescriptorField for the rationale behind
     * this (admittedly ugly) approach.
     *
     * @param descriptor descriptor to decode
     * @return the dedoced descriptor
     */
    public static JAXXObjectDescriptor decodeJAXXObjectDescriptor(
            String descriptor) {
        try {
            return (JAXXObjectDescriptor) Base64Coder.deserialize(descriptor, false);
        } catch (IOException e) {
            throw new RuntimeException("Internal error: can't-happen error", e);
        } catch (ClassNotFoundException e) {
            throw new RuntimeException("Internal error: can't-happen error", e);
        }
    }

    public static JAXXObjectDescriptor decodeCompressedJAXXObjectDescriptor(
            String descriptor) {
        try {
            return (JAXXObjectDescriptor) Base64Coder.deserialize(descriptor, true);
        } catch (IOException e) {
            throw new RuntimeException("Internal error: can't-happen error", e);
        } catch (ClassNotFoundException e) {
            throw new RuntimeException("Internal error: can't-happen error", e);
        }
    }
}
