package org.nuiton.jaxx.demo.component.swing;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.LayoutManager;
import javax.swing.ButtonModel;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.swing.HBox;
import static org.nuiton.i18n.I18n.t;

public class JToggleButtonDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWTvW4TQRDHx07sxPmAfAgQDYoS50MC7khDkyiQxIpCZAgiFBFuWPtW9kXn3WV3Lj4oUlDQ8QIUtDQo7xBRIdHQ5h2Q8gjMnh3bQWcnwBV3q7mZ3/xndubrL8gYDfekrjoi9FEK54BFkaNDgX6dOzvr+/u75QNewQI3Fe0rlBqaTyoN6RKMem27QXBKRSK5TZJrSW6L5G7KupKCiy7QShFGDL4NuKlxjghLPYMrxrh7bc+VSIW6lStRdVKuHx+WT1O88CkNECmSn6Wy7/4FoFP1YBHSvocwVTxgh8wNmKiSOO2LKhU0bm2bATPmGavzN3AEQ0XIKqYJhnD/n9oT42JUpBBG8wVel8+Z4MEDhId/luDRT6dyTnNMg3Q5Oy9ltRrwjRDJz4YrFQOzCNn89oaMiDTbqxlNhPWyIbl25ABlQLhtC46S8li3sY43NqQ9Tl40Z7CmOU/4MZzfKbJyXOPUhRSxteWrYaGXahoZpzMyndtLlSCjQzIjzPWeVjtwL8irOWpzvUfNpokd3x8f6S+Ns9Pu+Zq5LKprleiylZaKa/SttuvN4QrRD9ynTK2UIGd4QHsY79lif+V7LU9STyomLcmxJGebmRrRMkOnJ99uvv45AOktGAkk87aY9X8COXsdpiYDL1KPHsfixhrD9J6wMhGma1L776RAFqwHflXU47GeWvVF4As+w5D2oBwiX4uobYv929ZWebx79v3zx/mT89alSHT+KpGd9mVeQbapIV7O1t4lLuOoMjz0ZGepktYsZb/jqrUmd+L3bFJDJg/tjVW62mFd56PQfhbiYuxp6crAQeRRP8bEpQxrXu5DmP5vwo2rERCurXoM2UzZFx7t7loy7RbRfgPxYItMiAYAAA==";
    private static final Log log = LogFactory.getLog(JToggleButtonDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JToggleButton one;
    protected JToggleButton three;
    protected JToggleButton two;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JToggleButtonDemo $DemoPanel0;
    private HBox $HBox0;
    private JLabel $JLabel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JToggleButtonDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JToggleButtonDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public JToggleButtonDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public JToggleButtonDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JToggleButtonDemo() {
        $initialize();
    }

    public JToggleButtonDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public JToggleButtonDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public JToggleButtonDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JToggleButton getOne() {
        return one;
    }

    public JToggleButton getThree() {
        return three;
    }

    public JToggleButton getTwo() {
        return two;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected HBox get$HBox0() {
        return $HBox0;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createOne() {
        $objectMap.put("one", one = new JToggleButton());
        
        one.setName("one");
        one.setText(t("1"));
    }

    protected void createThree() {
        $objectMap.put("three", three = new JToggleButton());
        
        three.setName("three");
        three.setText(t("3"));
    }

    protected void createTwo() {
        $objectMap.put("two", two = new JToggleButton());
        
        two.setName("two");
        two.setText(t("2"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $HBox0
        $objectMap.put("$HBox0", $HBox0 = new HBox());
        
        $HBox0.setName("$HBox0");
        $HBox0.setHorizontalAlignment(0);
        $HBox0.setVerticalAlignment(0);
        createOne();
        createTwo();
        createThree();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JLABEL0_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (one != null) {
                    $bindingSources.put("one.getModel()", one.getModel());
                    one.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    one.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JToggleButtonDemo.this, BINDING_$JLABEL0_TEXT));
                }
                if (two != null) {
                    $bindingSources.put("two.getModel()", two.getModel());
                    two.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    two.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JToggleButtonDemo.this, BINDING_$JLABEL0_TEXT));
                }
                if (three != null) {
                    $bindingSources.put("three.getModel()", three.getModel());
                    three.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    three.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JToggleButtonDemo.this, BINDING_$JLABEL0_TEXT));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (one != null && two != null && three != null) {
                    $JLabel0.setText(t("Total: " + ((one.isSelected() ? 1 : 0) + (two.isSelected() ? 2 : 0) + (three.isSelected() ? 3 : 0))));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (one != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("one.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    one.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JToggleButtonDemo.this, BINDING_$JLABEL0_TEXT));
                }
                if (two != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("two.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    two.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JToggleButtonDemo.this, BINDING_$JLABEL0_TEXT));
                }
                if (three != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("three.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    three.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.swing.JToggleButtonDemo.this, BINDING_$JLABEL0_TEXT));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($HBox0);
        // inline complete setup of $HBox0
        $HBox0.add(one);
        $HBox0.add(two);
        $HBox0.add(three);
        $HBox0.add($JLabel0);
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}