package jaxx.compiler.binding;

import jaxx.compiler.finalizers.DefaultFinalizer;
import jaxx.compiler.java.JavaFileGenerator;
import jaxx.compiler.java.JavaMethod;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;

import java.lang.reflect.Modifier;
import java.util.List;

/**
 * Created: 5 déc. 2009
 *
 * @author Tony Chemit <chemit@codelutin.com> Copyright Code Lutin
 * @version $Revision:  $
 *          <p/>
 *          Mise a jour: $Date:  $ par :
 *          $Author: tchemit $
 */
public class SimpleJAXXObjectBindingWriter extends AbstractJAXXBindingWriter<SimpleJAXXObjectBinding> {

    protected boolean used;

    public SimpleJAXXObjectBindingWriter() {
        super(SimpleJAXXObjectBinding.class);
    }

    @Override
    public boolean accept(DataBinding binding) {
        DataListener[] trackers = binding.getTrackers();
        if (trackers.length > 0) {
            for (DataListener tracker : trackers) {
                if (tracker.getObjectCode() != null) {
                    // tracker must be without any requirement
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    protected String getConstructorParams(DataBinding binding, DataListener[] trackers) {

        StringBuilder addBuffer = new StringBuilder();
        addBuffer.append("this, ").append(binding.getConstantId()).append(", true");

        for (DataListener tracker : trackers) {
            String symbol = tracker.getSymbol();
            String propertyName = symbol.substring(symbol.indexOf(".") + 1);
            if (JavaParserUtil.getMethodInvocationParameters(propertyName) != null) {
                // obtain the property name from the method name
                propertyName = JavaParserUtil.getPropertyNameFromMethod(propertyName);
            }
            addBuffer.append(" ,\"").append(propertyName).append("\"");
        }
        return addBuffer.toString();
    }

    @Override
    public void write(DataBinding binding, JavaFileGenerator generator, StringBuilder buffer) {
        DataListener[] trackers = binding.getTrackers();
        List<JavaMethod> bMethods = binding.getMethods();

        bMethods.add(0, JavaFileGenerator.newMethod(Modifier.PUBLIC, DefaultFinalizer.TYPE_VOID, DefaultFinalizer.METHOD_NAME_PROCESS_DATA_BINDING, binding.getProcessDataBinding(), true));

        writeInvocationMethod(binding, trackers, generator, buffer, bMethods);
    }
}