/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.types;

import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.types.TypeConverter;

public class PrimitiveConverter
implements TypeConverter {
    @Override
    public Class<?>[] getSupportedTypes() {
        return new Class[]{Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Character.TYPE, Character.class, String.class};
    }

    @Override
    public String getJavaCode(Object object) {
        if (object instanceof Boolean) {
            return String.valueOf((Boolean)object);
        }
        if (object instanceof Byte) {
            return String.valueOf(((Byte)object).byteValue());
        }
        if (object instanceof Short) {
            return String.valueOf(((Short)object).shortValue());
        }
        if (object instanceof Integer) {
            return String.valueOf((Integer)object);
        }
        if (object instanceof Long) {
            return String.valueOf((Long)object) + "L";
        }
        if (object instanceof Float) {
            return String.valueOf(((Float)object).floatValue()) + "F";
        }
        if (object instanceof Double) {
            return String.valueOf((Double)object);
        }
        if (object instanceof String) {
            return '\"' + JAXXCompiler.escapeJavaString((String)object) + '\"';
        }
        throw new IllegalArgumentException("unsupported object: " + object);
    }

    @Override
    public Object convertFromString(String string, Class<?> type) {
        if (type == String.class || type == Object.class || type == null) {
            return string;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return Integer.valueOf(string);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            if (string.toLowerCase().equals("true")) {
                return Boolean.TRUE;
            }
            if (string.toLowerCase().equals("false")) {
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException("expected 'true' or 'false', found '" + string + "'");
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return Byte.valueOf(string);
        }
        if (type == Short.TYPE || type == Short.class) {
            return Short.valueOf(string);
        }
        if (type == Long.TYPE || type == Long.class) {
            return Long.valueOf(string);
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(string);
        }
        if (type == Double.TYPE || type == Double.class) {
            return Double.valueOf(string);
        }
        if (type == Character.TYPE || type == Character.class) {
            if (string.length() == 1) {
                return Character.valueOf(string.charAt(0));
            }
            throw new IllegalArgumentException("expected a single character, found '" + string + "'");
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }
}

