package org.nuiton.jaxx.application.swing.action;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.ApplicationUIContext;
import org.nuiton.jaxx.application.swing.util.ApplicationUIUtil;
import org.nuiton.jaxx.runtime.JAXXBinding;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObject;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.SwingUtil;
import org.nuiton.jaxx.runtime.context.DefaultJAXXContext;
import org.nuiton.jaxx.runtime.swing.BlockingLayerUI;

public class ApplicationActionUI extends JDialog implements ApplicationUI<ApplicationActionUIModel, ApplicationActionUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAMVWz28bRRQeu7VT24QmoVRUosioLXXUsG4l2ksiID+oSOT+UEulilw6653ak4x3tjNv67WiVqIHbhzhwIErF9T/oeKExIVr/gek/gm8md14bWedOIkAyx6t37z53nvfvvft/vY3KWhFFqRqOX7IQfrOFo0iR4U+8A5zNpYfP77nbrEmrDHdVDwAqUj8yeVJfpNUvL5dA3E2G4hUj5HqBqmeINVXZSeQPvMHgBYbpKyhJ5huMwZAamMPN7WuP+x7LkZBqJJYmVlnxfrz+xu7Obb2c56QKMD0y1j2tSMApFWfbpA894DMNbboc1oX1G9hcor7LSxo2thWBdX6Lu2wZ+QlmWqQYkAVggH59Fj0WDgLFQVASpc31jgVsnUdyNJoATQIBG9S4GjQXUzJoU37ZzndWLaWR+tBYEGLQGbcUPdWhGxuN2iPqUfrmOk4amJU64wXiX8KVehIjwkgyyfJ7I7BSDFLSkq4T32DO2f4jRKEDWs0XqW+c6UlpEtFf+ecWeb627PxdhypQd39mNZovN8fPXRfyZZiWq9QBeSD4UTSreGjJaB6e1wyZ83mQCrGfMEsF4ddRtA/TFwU+WTcXcKBcdKBSXs3t0kKKkQzkEvjZ9WM2wP0igft0vhBM2Gs46vXL9Wv3be7e9M1i8lVDzs1ICTY6oGSAVPATW5n49EKgYv6HRosbpKSZgJVyKrM1YMzf5h4YvaYxaxBcgyS8zXVbUQrTO2++f38k79OkfxtUhaSerep8V/Hm9VGmttSeFHwxZc2uXe6Z3Cdwd8pIFOhZutN6WObP6VCI7EF1wwCkOIOqJC9ADLtJpOxKoXENnF22tT3BFNOi8EqHmUR1ObjP+gwNEe1+RcR8n31YL775b2+9/aPX3648maP8xxWe3mSkynvhW9JkfuC+8xqWiJXmRpWCTQLPZlqUZY6kQwtCZJBrtl1YR+vOWTPlcrDe08+3vFZt/oNB8G8FWur1WJpna/6oRCGIIPymS3XXN0iwyN/lGgXbbSvOgH0kmA3F6rJNzvSfvWYIN409z0GTHW4TwF75rRplQPQB6b9MPT8kbjDBn7ONXcF22vgrCxSxTpGbeNhR4Xs371Ro8r6fxA5w/2nUnXsk+0/6M3BcJPWXI6fwbGmVQYATJeiUhkiQwC+96yW21mRz8iE6kkKbDPeaiPw3FIsPFUKyK0bAvt8H3bOrOUJUM1bB7WPz++OD1IJsZebUmEjeyeEKnTxBbF9QpCioD2J7JN3lzwKtOrirGETjqHpvUMRjflHs/yUjXD+xAgfIcI/LwEO8VIMAAA=";
    private static final Log log = LogFactory.getLog(ApplicationActionUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected BlockingLayerUI busyBlockLayerUI;
    protected JLabel globalActionLabel;
    protected JPanel globalPanel;
    protected JProgressBar globalProgressBar;
    protected ApplicationActionUIHandler handler;
    protected ApplicationActionUIModel model;
    protected JPanel rootPanel;
    protected JLabel taskActionLabel;
    protected JPanel taskPanel;
    protected JProgressBar taskProgressBar;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ApplicationActionUI $JDialog0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
        public void open(AbstractApplicationAction action) {
          getModel().setAction(action);
        }
    
        public void close() {
          getModel().clear();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ApplicationActionUI(JFrame frame, ApplicationUIContext context) {
        super(frame, true);
                ApplicationUIUtil.setApplicationContext(this, context);
            $initialize();
    }

    public ApplicationActionUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI() {
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Window param0) {
        super(param0);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ApplicationActionUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ApplicationActionUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if ($bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if ($bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public BlockingLayerUI getBusyBlockLayerUI() {
        return busyBlockLayerUI;
    }

    public JLabel getGlobalActionLabel() {
        return globalActionLabel;
    }

    public JPanel getGlobalPanel() {
        return globalPanel;
    }

    public JProgressBar getGlobalProgressBar() {
        return globalProgressBar;
    }

    public ApplicationActionUIHandler getHandler() {
        return handler;
    }

    public ApplicationActionUIModel getModel() {
        return model;
    }

    public JPanel getRootPanel() {
        return rootPanel;
    }

    public JLabel getTaskActionLabel() {
        return taskActionLabel;
    }

    public JPanel getTaskPanel() {
        return taskPanel;
    }

    public JProgressBar getTaskProgressBar() {
        return taskProgressBar;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToGlobalPanel() {
        globalPanel.add(globalActionLabel, BorderLayout.CENTER);
        globalPanel.add(globalProgressBar, BorderLayout.SOUTH);
    }

    protected void addChildrenToRootPanel() {
        rootPanel.add(globalPanel, BorderLayout.NORTH);
        rootPanel.add(taskPanel, BorderLayout.CENTER);
    }

    protected void addChildrenToTaskPanel() {
        taskPanel.add(taskActionLabel, BorderLayout.CENTER);
        taskPanel.add(taskProgressBar, BorderLayout.SOUTH);
    }

    protected void createBusyBlockLayerUI() {
        $objectMap.put("busyBlockLayerUI", busyBlockLayerUI = new BlockingLayerUI());
        
        busyBlockLayerUI.setUseIcon(false);
    }

    protected void createGlobalActionLabel() {
        $objectMap.put("globalActionLabel", globalActionLabel = new JLabel());
        
        globalActionLabel.setName("globalActionLabel");
    }

    protected void createGlobalPanel() {
        $objectMap.put("globalPanel", globalPanel = new JPanel());
        
        globalPanel.setName("globalPanel");
        globalPanel.setLayout(new BorderLayout());
    }

    protected void createGlobalProgressBar() {
        $objectMap.put("globalProgressBar", globalProgressBar = new JProgressBar());
        
        globalProgressBar.setName("globalProgressBar");
        globalProgressBar.setIndeterminate(true);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(ApplicationActionUIModel.class));
    }

    protected void createRootPanel() {
        $objectMap.put("rootPanel", rootPanel = new JPanel());
        
        rootPanel.setName("rootPanel");
        rootPanel.setLayout(new BorderLayout());
    }

    protected void createTaskActionLabel() {
        $objectMap.put("taskActionLabel", taskActionLabel = new JLabel());
        
        taskActionLabel.setName("taskActionLabel");
    }

    protected void createTaskPanel() {
        $objectMap.put("taskPanel", taskPanel = new JPanel());
        
        taskPanel.setName("taskPanel");
        taskPanel.setLayout(new BorderLayout());
        taskPanel.setVisible(false);
    }

    protected void createTaskProgressBar() {
        $objectMap.put("taskProgressBar", taskProgressBar = new JProgressBar());
        
        taskProgressBar.setName("taskProgressBar");
        taskProgressBar.setIndeterminate(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $JDialog0 = this;
        handler = new ApplicationActionUIHandler();
        handler.beforeInit(this);
        $initialize_01_createComponents();
        $initialize_02_registerDataBindings();
        $initialize_03_finalizeCreateComponents();
        $initialize_04_applyDataBindings();
        $initialize_05_setProperties();
        $initialize_06_finalizeInitialize();
        handler.afterInit(this);
    }

    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JDialog0", $JDialog0);
        createBusyBlockLayerUI();
        createModel();
        createRootPanel();
        createGlobalPanel();
        createGlobalActionLabel();
        createGlobalProgressBar();
        createTaskPanel();
        createTaskActionLabel();
        createTaskProgressBar();
        // inline creation of $JDialog0
        setName("$JDialog0");
        SwingUtil.setComponentHeight($JDialog0,200);
        setModal(true);
        setUndecorated(true);
        SwingUtil.setComponentWidth($JDialog0,300);
    }

    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // register 0 data bindings
    }

    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JDialog0
        add(SwingUtil.boxComponentWithJxLayer(rootPanel), BorderLayout.CENTER);
        addChildrenToRootPanel();
        addChildrenToGlobalPanel();
        addChildrenToTaskPanel();
    }

    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        
        // apply 9 property setters
        busyBlockLayerUI.setBlock(true);
        busyBlockLayerUI.setBlockingColor(handler.getContext().getColorBlockingLayer());
        globalPanel.setBorder(new TitledBorder((String) null));
        globalActionLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
        taskPanel.setBorder(new TitledBorder((String) null));
        taskActionLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
    }

    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
    }

}