package org.nuiton.jaxx.application.swing.tab;

/*
 * #%L
 * JAXX :: Application Swing
 * $Id: TabHandler.java 2824 2014-05-08 10:07:12Z kmorin $
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Code Lutin, Tony CHEMIT
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

/**
 * Interface describing UI contained in a tab.
 *
 * @author kmorin <kmorin@codelutin.com>
 * @since 2.8
 */
public interface TabHandler {

    /**
     * Method called when the tab is hidden
     *
     * @param currentIndex
     * @param newIndex
     * @return <code>false</code> to prevent the tab to be hidden,
     * <code>true</code> otherwise.
     */
    boolean onHideTab(int currentIndex, int newIndex);

    /**
     * Method called when the tab is shown
     *
     * @param currentIndex
     * @param newIndex
     */
    void onShowTab(int currentIndex, int newIndex);

    /**
     * Method called when the tab is removed
     *
     * @return <code>false</code> to prevent the tab to be closed,
     * <code>true</code> otherwise.
     */
    boolean onRemoveTab();
}
