/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.application.swing.action;

import com.google.common.base.Preconditions;
import javax.swing.AbstractButton;
import javax.swing.Action;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;
import org.nuiton.jaxx.application.swing.action.AbstractApplicationAction;
import org.nuiton.jaxx.application.swing.action.ApplicationUIAction;

public class ApplicationActionFactory {
    public <A extends AbstractApplicationAction> ApplicationUIAction<A> createUIAction(AbstractApplicationUIHandler handler, Class<A> actionName) {
        return this.createUIAction(handler, null, actionName);
    }

    public <A extends AbstractApplicationAction> ApplicationUIAction<A> createUIAction(AbstractApplicationUIHandler handler, AbstractButton abstractButton, Class<A> actionName) {
        try {
            A logicAction = this.createLogicAction(handler, actionName);
            return this.createUIAction(abstractButton, logicAction);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"jaxx.application.action.create.error", (Object[])new Object[]{actionName}), (Throwable)e);
        }
    }

    public <A extends AbstractApplicationAction> ApplicationUIAction<A> createUIAction(AbstractButton abstractButton, A logicAction) {
        return new ApplicationUIAction<A>(abstractButton, logicAction);
    }

    public <A extends AbstractApplicationAction> A createLogicAction(AbstractApplicationUIHandler handler, Class<A> actionName) {
        try {
            return (A)((Object)((AbstractApplicationAction)((Object)ConstructorUtils.invokeConstructor(actionName, (Object[])new Object[]{handler}))));
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"jaxx.application.action.create.error", (Object[])new Object[]{actionName}), (Throwable)e);
        }
    }

    public <A extends AbstractApplicationAction> A getLogicAction(AbstractButton b) {
        Action action = b.getAction();
        Preconditions.checkNotNull((Object)action);
        Preconditions.checkState((boolean)(action instanceof ApplicationUIAction));
        return ((ApplicationUIAction)action).getLogicAction();
    }
}

