/**
 * *##% guix-compiler
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */

package org.nuiton.guix.generator;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.guix.model.GuixModelObject;
import org.nuiton.guix.tags.TagHandler;
import org.xmlpull.v1.XmlSerializer;

/**
 * Abstract class of the Guix generators.
 *
 * @author kevin
 */
public abstract class GuixGenerator implements Generator {

    /** GuixModelObject which represents the class to generate */
    protected GuixModelObject gmo = null;
    /** Source directory */
    protected File srcDir = null;
    /** Destination directory of the generated file */
    protected File destDir = null;
    /** True if the class to generate is teh main class of the application */
    protected boolean mainClass = false;
    /** Time of the last modification of one of the file implied in the process */
    protected Long lastModification = null;
    /** XML serializer to generate the spring conf */
    protected XmlSerializer serializer = null;
    /** List of the classes to generate */
    protected Map<String, JavaFile> classes = null;
    /** List of the CSS files needed of the generation */
    protected List<File> cssFiles = null;
    /** Name to give to the generated launcher*/
    protected String launcherName = null;
    /** Maps the field name with a map of the attribute and its value */
    protected Map<String,Map<String, String>> bindings2Generate = new HashMap<String,Map<String, String>>();
    /** List of the user file names containing the addPropertyChangeListener method */
    protected List<JavaFile> propertyChangeListenerDependencies = new ArrayList<JavaFile>();

    /**
     * Generates a JavaFile
     * 
     * @return the JavaFile generated
     */
    public abstract JavaFile generate();

    public File getSrcDir() {
        return srcDir;
    }

    public void setSrcDir(File srcDir) {
        this.srcDir = srcDir;
    }

    public File getDestDir() {
        return destDir;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public GuixModelObject getGmo() {
        return gmo;
    }

    public void setGmo(GuixModelObject gmo) {
        this.gmo = gmo;
    }

    public Long getLastModification() {
        return lastModification;
    }

    public void setLastModification(Long lastModification) {
        this.lastModification = lastModification;
    }

    public boolean isMainClass() {
        return mainClass;
    }

    public void setMainClass(boolean mainClass) {
        this.mainClass = mainClass;
    }

    public XmlSerializer getSerializer() {
        return serializer;
    }

    public void setSerializer(XmlSerializer serializer) {
        this.serializer = serializer;
    }

    public Map<String, JavaFile> getClasses() {
        return classes;
    }

    public void setClasses(Map<String, JavaFile> classes) {
        this.classes = classes;
    }


    public List<File> getCSSFiles() {
        return cssFiles;
    }

    public void setCSSFiles(List<File> cssFiles) {
        this.cssFiles = cssFiles;
    }

    public String getLauncherName() {
        return launcherName;
    }

    public void setLauncherName(String launcherName) {
        this.launcherName = launcherName;
    }

    public Map<String,Map<String, String>> getBindingsToGenerate() {
        return bindings2Generate;
    }

    public void setBindingsToGenerate(Map<String,Map<String, String>> bindings2Generate) {
        this.bindings2Generate = bindings2Generate;
    }

    public List<JavaFile> getPropertyChangeListenerDependencies() {
        return propertyChangeListenerDependencies;
    }

    public void setPropertyChangeListenerDependencies(List<JavaFile> propertyChangeListenerDependencies) {
        this.propertyChangeListenerDependencies = propertyChangeListenerDependencies;
    }

    /**
     * Saves the generated files
     */
    public abstract void saveFiles();

    /**
     * Checks if the objects of the binding exist
     * and determines which objects need a listener
     *
     * @param dbCreation the method code to apply the binding
     * @param dbDeletion the method code to remove the binding
     * @param prevTh the TagHandler of the parent of the object inspected
     * @param jf the javaFile of the inspected object (null if it is not a generated object)
     * @param clazz the clazz of the inspected object (null if it is a generated object)
     * @param binding the array containing the name of the objects to check
     * @param i the index of the being checked object
     * @param alreadyChecked list of the already checked objects
     * @param methodToInvoke the name of the method which will process the databinding
     * @param generatedFiles maps the GuixGenerator with its JavaFile
     * @return the list of the listeners to add to the objects for the databinding
     */
    public abstract List<Class> generateBindings(StringBuffer dbCreation, StringBuffer dbDeletion, TagHandler prevTh, JavaFile jf,
            Class clazz, String[] binding, int i, List<String> alreadyChecked, String methodToInvoke, Map<GuixGenerator,JavaFile> generatedFiles);
}
