/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.nuiton.eugene.ModelReader;
import org.nuiton.eugene.Template;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.plugin.EugeneAbstractMojo;
import org.nuiton.plugin.PluginHelper;
import org.nuiton.plugin.PluginIOContext;

@Deprecated
public class EugenePlugin
extends EugeneAbstractMojo {
    protected PluginIOContext generateResources;
    protected String templates;
    protected String[] excludeTemplates;
    protected String includes;
    protected String defaultPackage;
    protected File extraClassPathDirectory;
    protected String generatedPackages;
    protected String reader;

    public void doAction() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Generating java sources from models");
        this.getLog().info((CharSequence)(" reader               : " + this.reader));
        this.getLog().info((CharSequence)(" includes             : " + this.includes));
        this.getLog().info((CharSequence)(" using template       : " + this.templates));
        this.getLog().info((CharSequence)(" using defaultPackage : " + this.defaultPackage));
        File[] modelFiles = this.getModelFiles();
        if (modelFiles.length == 0) {
            this.getLog().warn((CharSequence)"no model to treate");
            return;
        }
        if (this.verbose) {
            for (File m : modelFiles) {
                this.getLog().info((CharSequence)("will treate model file : " + m));
            }
        }
        ModelReader<?> modelReader = this.getReader();
        this.generate(modelFiles, modelReader);
        this.fixCompileSourceRoots();
    }

    protected <M extends Model> void generate(File[] modelFiles, ModelReader<M> modelReader) throws MojoFailureException, MojoExecutionException {
        if (modelReader == null) {
            this.getLog().warn((CharSequence)"no reader to use");
            return;
        }
        Model model = modelReader.read(modelFiles);
        if (StringUtils.isEmpty((String)this.generatedPackages)) {
            this.getLog().info((CharSequence)" generating all packages");
        } else {
            this.getLog().info((CharSequence)(" generating only for packages " + this.generatedPackages));
        }
        List<Template<M>> templatesList = this.getTemplates(modelReader);
        for (Template<M> template : templatesList) {
            this.getLog().info((CharSequence)("Apply " + template.getClass().getSimpleName() + " generator"));
            try {
                template.applyTemplate(model, this.generateResources.getOutput());
            }
            catch (IOException eee) {
                throw new MojoExecutionException("Generation problem", (Exception)eee);
            }
        }
    }

    @Override
    protected PluginIOContext getResources() {
        return this.generateResources;
    }

    @Override
    protected PluginIOContext initResources() {
        File defaultIn = this.getFileFromBasedir(new String[]{"target", "generated-sources", "models"});
        File defaultOut = this.getFileFromBasedir(new String[]{"target", "generated-sources", "java"});
        File defaultTestIn = this.getFileFromBasedir(new String[]{"target", "generated-sources", "test-models"});
        File defaultTestOut = this.getFileFromBasedir(new String[]{"target", "generated-sources", "test-java"});
        this.generateResources = this.initResources(defaultIn, defaultOut, defaultTestIn, defaultTestOut);
        return this.generateResources;
    }

    protected File[] getModelFiles() {
        ArrayList modelFiles = new ArrayList();
        Object[] includePatterns = this.includes.split(",");
        for (File srcDirGen : this.generateResources.getInputs()) {
            if (this.verbose) {
                this.getLog().info((CharSequence)("Search for " + Arrays.toString(includePatterns) + " in " + srcDirGen.getAbsolutePath()));
            }
            List currentFiles = PluginHelper.getIncludedFiles((File)srcDirGen, (String[])includePatterns, null);
            modelFiles.addAll(currentFiles);
        }
        return modelFiles.toArray(new File[modelFiles.size()]);
    }

    protected ModelReader<?> getReader() throws MojoFailureException, MojoExecutionException {
        ModelReader modelReader;
        try {
            ClassLoader fixedClassLoader = this.fixClassLoader();
            modelReader = (ModelReader)Class.forName(this.reader, true, fixedClassLoader).newInstance();
        }
        catch (InstantiationException eee) {
            throw new MojoFailureException("Can't instantiate reader : " + this.reader, (Throwable)eee);
        }
        catch (IllegalAccessException eee) {
            throw new MojoFailureException("Can't access reader : " + this.reader, (Throwable)eee);
        }
        catch (ClassNotFoundException eee) {
            throw new MojoFailureException("Can't found reader : " + this.reader, (Throwable)eee);
        }
        return modelReader;
    }

    protected <M extends Model> List<Template<M>> getTemplates(ModelReader<M> modelReader) throws MojoFailureException, MojoExecutionException {
        Properties templateProperties = new Properties();
        templateProperties.setProperty("defaultPackage", this.defaultPackage);
        templateProperties.setProperty("overwrite", String.valueOf(this.overwrite));
        templateProperties.setProperty("encoding", this.encoding);
        templateProperties.setProperty("lastModifiedSource", String.valueOf(modelReader.getLastModifiedSource()));
        if (this.generatedPackages != null) {
            templateProperties.setProperty("generatedPackages", this.generatedPackages);
        }
        templateProperties.setProperty("excludeTemplates", this.getExcludeTemplatesAsString());
        ArrayList<Template<M>> templatesList = new ArrayList<Template<M>>();
        String[] templatesNames = this.templates.split(",");
        ClassLoader fixedClassLoader = this.fixClassLoader();
        for (String templateName : templatesNames) {
            templateName = templateName.trim();
            try {
                Template template = (Template)Class.forName(templateName, true, fixedClassLoader).newInstance();
                template.setProperties(templateProperties);
                templatesList.add(template);
            }
            catch (InstantiationException e) {
                throw new MojoFailureException("Can't instantiate generator : " + templateName, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new MojoFailureException("Can't access generator : " + templateName, (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new MojoFailureException("Can't found generator : " + templateName, (Throwable)e);
            }
        }
        return templatesList;
    }

    protected String getExcludeTemplatesAsString() {
        String result = "";
        for (int i = 0; i < this.excludeTemplates.length; ++i) {
            result = result + this.excludeTemplates[i];
            if (i == this.excludeTemplates.length - 1) continue;
            result = result + ",";
        }
        return result;
    }

    protected void fixCompileSourceRoots() {
        if (this.project == null) {
            return;
        }
        File destDirGen = this.generateResources.getOutput();
        if (this.testPhase) {
            if (!this.project.getTestCompileSourceRoots().contains(destDirGen.getPath())) {
                this.getLog().info((CharSequence)("Add test compile source root : " + destDirGen));
                this.project.addTestCompileSourceRoot(destDirGen.getPath());
                Resource resources = new Resource();
                resources.setDirectory(destDirGen.getAbsolutePath());
                resources.setExcludes(Arrays.asList("**/*.java"));
                this.getLog().info((CharSequence)("Add test resource root :" + resources));
                this.project.addTestResource(resources);
            }
        } else if (!this.project.getCompileSourceRoots().contains(destDirGen.getPath())) {
            this.getLog().info((CharSequence)("Add compile source root : " + destDirGen));
            this.project.addCompileSourceRoot(destDirGen.getPath());
            Resource resources = new Resource();
            resources.setDirectory(destDirGen.getAbsolutePath());
            resources.setExcludes(Arrays.asList("**/*.java"));
            this.getLog().info((CharSequence)("Add resource root :" + resources));
            this.project.addResource(resources);
        }
    }

    protected ClassLoader fixClassLoader() throws MojoExecutionException {
        ArrayList urls = new ArrayList();
        HashSet urlsAsString = new HashSet();
        try {
            ClassLoader loader = null;
            if (this.extraClassPathDirectory != null) {
                if (this.verbose) {
                    this.getLog().info((CharSequence)("Add extra directory in generator's classLoader : " + this.extraClassPathDirectory));
                }
                this.addDirectoryToUrlsList(this.extraClassPathDirectory, urls, urlsAsString);
            }
            if (this.project.getProjectReferences() != null) {
                Iterator i$ = this.project.getProjectReferences().entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = i$.next();
                    MavenProject relatedProject = (MavenProject)entry.getValue();
                    if (this.verbose) {
                        this.getLog().info((CharSequence)("Add project reference in generator's classLoader : '" + relatedProject.getArtifact() + "'"));
                    }
                    this.addDirectoryToUrlsList(relatedProject.getArtifact().getFile(), urls, urlsAsString);
                }
            }
            if (!this.project.getArtifacts().isEmpty()) {
                if (this.verbose) {
                    this.getLog().info((CharSequence)"Use resolved artifacts to build class-path");
                }
                for (Map.Entry o : this.project.getArtifacts()) {
                    Artifact a = (Artifact)o;
                    if (a.getScope().equals("provided")) continue;
                    this.addDirectoryToUrlsList(a.getFile(), urls, urlsAsString);
                }
            }
            loader = ((Object)((Object)this)).getClass().getClassLoader();
            if (!urls.isEmpty()) {
                loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), loader);
            }
            ClassLoader classLoader = loader;
            return classLoader;
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        finally {
            urls.clear();
            urlsAsString.clear();
        }
    }
}

