/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp;

import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.transport.AbstractMuleMessageFactory;

public class XmppMuleMessageFactory
extends AbstractMuleMessageFactory {
    public XmppMuleMessageFactory(MuleContext context) {
        super(context);
    }

    protected Class<?>[] getSupportedTransportMessageTypes() {
        return new Class[]{Packet.class};
    }

    protected Object extractPayload(Object transportMessage, String encoding) throws Exception {
        return transportMessage;
    }

    protected void addProperties(DefaultMuleMessage message, Object transportMessage) throws Exception {
        super.addProperties(message, transportMessage);
        Packet packet = (Packet)transportMessage;
        message.setUniqueId(packet.getPacketID());
        HashMap<String, Object> properties = new HashMap<String, Object>();
        this.addXmppPacketProperties(packet, properties);
        if (packet instanceof Message) {
            Message xmppMessage = (Message)packet;
            this.addXmppMessageProperties(xmppMessage, properties);
        }
        message.addInboundProperties(properties);
    }

    private void addXmppPacketProperties(Packet packet, Map<String, Object> properties) {
        for (String key : packet.getPropertyNames()) {
            properties.put(key, packet.getProperty(key));
        }
    }

    private void addXmppMessageProperties(Message message, Map<String, Object> properties) {
        properties.put("subject", message.getSubject());
        properties.put("thread", message.getThread());
    }
}

