/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.xmpp.transformers;

import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.XMPPError;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageAwareTransformer;

public class ObjectToXmppPacket
extends AbstractMessageAwareTransformer {
    public ObjectToXmppPacket() {
        this.registerSourceType(String.class);
        this.registerSourceType(Message.class);
        this.setReturnClass(Message.class);
    }

    public Object transform(MuleMessage msg, String outputEncoding) throws TransformerException {
        Object src = msg.getPayload();
        if (src instanceof Message) {
            return src;
        }
        Message result = new Message();
        if (msg.getExceptionPayload() != null) {
            result.setError(new XMPPError(503, msg.getExceptionPayload().getMessage()));
        }
        for (String name : msg.getPropertyNames()) {
            if (name.equals("thread")) {
                result.setThread((String)msg.getProperty(name));
                continue;
            }
            if (name.equals("subject")) {
                result.setSubject((String)msg.getProperty(name));
                continue;
            }
            if (name.equals("from")) {
                result.setFrom((String)msg.getProperty(name));
                continue;
            }
            if (name.equals("to")) {
                result.setTo((String)msg.getProperty(name));
                continue;
            }
            result.setProperty(name, msg.getProperty(name));
        }
        result.setBody((String)src);
        return result;
    }
}

