/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.vm;

import org.mule.api.MuleContext;
import org.mule.api.transaction.TransactionException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transaction.AbstractSingleResourceTransaction;
import org.mule.transaction.IllegalTransactionStateException;
import org.mule.util.queue.QueueManager;
import org.mule.util.queue.QueueSession;
import org.mule.util.xa.ResourceManagerException;

public class VMTransaction
extends AbstractSingleResourceTransaction {
    public VMTransaction(MuleContext muleContext) throws TransactionException {
        QueueManager qm = muleContext.getQueueManager();
        QueueSession qs = qm.getQueueSession();
        this.bindResource(qm, qs);
    }

    public void bindResource(Object key, Object resource) throws TransactionException {
        if (!(key instanceof QueueManager) || !(resource instanceof QueueSession)) {
            throw new IllegalTransactionStateException(CoreMessages.transactionCanOnlyBindToResources((String)"QueueManager/QueueSession"));
        }
        super.bindResource(key, resource);
    }

    protected void doBegin() throws TransactionException {
        try {
            ((QueueSession)this.resource).begin();
        }
        catch (ResourceManagerException e) {
            throw new TransactionException(CoreMessages.cannotStartTransaction((String)"VMTransaction"), (Throwable)e);
        }
    }

    protected void doCommit() throws TransactionException {
        try {
            ((QueueSession)this.resource).commit();
        }
        catch (ResourceManagerException e) {
            throw new TransactionException(CoreMessages.transactionCommitFailed(), (Throwable)e);
        }
    }

    protected void doRollback() throws TransactionException {
        try {
            ((QueueSession)this.resource).rollback();
        }
        catch (ResourceManagerException e) {
            throw new TransactionException(CoreMessages.transactionRollbackFailed(), (Throwable)e);
        }
    }
}

