/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.vm;

import org.mule.api.MuleMessage;
import org.mule.api.ThreadSafeAccess;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.transport.AbstractMessageRequester;
import org.mule.transport.vm.VMConnector;
import org.mule.util.queue.Queue;
import org.mule.util.queue.QueueSession;

public class VMMessageRequester
extends AbstractMessageRequester {
    private final VMConnector connector;

    public VMMessageRequester(InboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (VMConnector)endpoint.getConnector();
    }

    protected MuleMessage doRequest(long timeout) throws Exception {
        if (!this.connector.isQueueEvents()) {
            throw new UnsupportedOperationException("Receive requested on VM Connector, but queueEvents is false");
        }
        QueueSession queueSession = this.connector.getQueueSession();
        Queue queue = queueSession.getQueue(this.endpoint.getEndpointURI().getAddress());
        if (queue == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No queue with name " + this.endpoint.getEndpointURI().getAddress()));
            }
            return null;
        }
        MuleMessage message = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Waiting for a message on " + this.endpoint.getEndpointURI().getAddress()));
        }
        try {
            message = (MuleMessage)queue.poll(timeout);
        }
        catch (InterruptedException e) {
            this.logger.error((Object)("Failed to receive message from queue: " + this.endpoint.getEndpointURI()));
        }
        if (message != null) {
            if (message instanceof ThreadSafeAccess) {
                ((ThreadSafeAccess)message).resetAccessControl();
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Message received: " + message));
            }
            return message;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("No event received after " + timeout + " ms"));
        }
        return null;
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
        if (this.connector.isQueueEvents()) {
            this.connector.getQueueProfile().configureQueue(this.endpoint.getEndpointURI().getAddress(), this.connector.getQueueManager());
        }
    }

    protected void doDisconnect() throws Exception {
    }
}

