/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import org.mule.config.spring.editors.QNamePropertyEditor;
import org.mule.transport.soap.NamedParameter;
import org.mule.util.ClassUtils;
import org.mule.util.StringUtils;

public class SoapMethod {
    private QName name;
    private List namedParameters = new ArrayList();
    private QName returnType;
    private Class returnClass = Object.class;

    public SoapMethod(String methodName, String paramsString) throws ClassNotFoundException {
        this(QNamePropertyEditor.convert((String)methodName), paramsString);
    }

    public SoapMethod(String methodName, List params) throws ClassNotFoundException {
        this(QNamePropertyEditor.convert((String)methodName), params);
    }

    public SoapMethod(QName methodName, String paramsString) throws ClassNotFoundException {
        this.name = methodName;
        ArrayList<String> params = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(paramsString, ",");
        while (stringTokenizer.hasMoreTokens()) {
            params.add(stringTokenizer.nextToken().trim());
        }
        this.initParams(params);
    }

    public SoapMethod(QName methodName, List params) throws ClassNotFoundException {
        this.name = methodName;
        this.initParams(params);
    }

    private void initParams(List params) throws ClassNotFoundException {
        for (String s : params) {
            StringTokenizer tokenizer = new StringTokenizer(s, ";");
            while (tokenizer.hasMoreTokens()) {
                String name = tokenizer.nextToken();
                String type = tokenizer.nextToken();
                if (name.equalsIgnoreCase("return")) {
                    if (type.startsWith("qname{")) {
                        this.returnType = QNamePropertyEditor.convert((String)type);
                        continue;
                    }
                    this.returnType = NamedParameter.createQName(type);
                    continue;
                }
                if (name.equalsIgnoreCase("returnClass")) {
                    this.returnClass = ClassUtils.loadClass((String)type, this.getClass());
                    continue;
                }
                String mode = tokenizer.nextToken();
                QName paramName = name.startsWith("qname{") ? QNamePropertyEditor.convert((String)name) : new QName(this.getName().getNamespaceURI(), name, this.getName().getPrefix());
                QName qtype = type.startsWith("qname{") ? QNamePropertyEditor.convert((String)type) : NamedParameter.createQName(type);
                NamedParameter param = new NamedParameter(paramName, qtype, mode);
                this.addNamedParameter(param);
            }
        }
    }

    public SoapMethod(QName name) {
        this.name = name;
        this.returnType = null;
    }

    public SoapMethod(QName name, QName returnType) {
        this.name = name;
        this.returnType = returnType;
    }

    public SoapMethod(QName name, QName returnType, Class returnClass) {
        this.name = name;
        this.returnType = returnType;
        this.returnClass = returnClass;
    }

    public SoapMethod(QName name, Class returnClass) {
        this.name = name;
        this.returnClass = returnClass;
    }

    public SoapMethod(QName name, List namedParameters, QName returnType) {
        this.name = name;
        this.namedParameters = namedParameters;
        this.returnType = returnType;
    }

    public void addNamedParameter(NamedParameter param) {
        this.namedParameters.add(param);
    }

    public NamedParameter addNamedParameter(QName name, QName type, String mode) {
        if (StringUtils.isBlank((String)name.getNamespaceURI())) {
            name = new QName(this.getName().getNamespaceURI(), name.getLocalPart(), name.getPrefix());
        }
        NamedParameter param = new NamedParameter(name, type, mode);
        this.namedParameters.add(param);
        return param;
    }

    public NamedParameter addNamedParameter(QName name, QName type, ParameterMode mode) {
        if (StringUtils.isBlank((String)name.getNamespaceURI())) {
            name = new QName(this.getName().getNamespaceURI(), name.getLocalPart(), name.getPrefix());
        }
        NamedParameter param = new NamedParameter(name, type, mode);
        this.namedParameters.add(param);
        return param;
    }

    public void removeNamedParameter(NamedParameter param) {
        this.namedParameters.remove(param);
    }

    public QName getName() {
        return this.name;
    }

    public List getNamedParameters() {
        return this.namedParameters;
    }

    public QName getReturnType() {
        return this.returnType;
    }

    public void setReturnType(QName returnType) {
        this.returnType = returnType;
    }

    public Class getReturnClass() {
        return this.returnClass;
    }

    public void setReturnClass(Class returnClass) {
        this.returnClass = returnClass;
    }
}

