/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jdbc.config;

import org.mule.transport.jdbc.config.AbstractDataSourceFactoryBean;

public class DerbyDataSourceFactoryBean
extends AbstractDataSourceFactoryBean {
    private static final String DRIVER_CLASS_NAME = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String JDBC_URL_PREFIX = "jdbc:derby:";
    private static final String MEMORY_SUB_SUBPROTOCOL = "memory";
    protected boolean create = false;
    protected String database;
    protected String subsubprotocol = "memory";

    public DerbyDataSourceFactoryBean() {
        this.driverClassName = DRIVER_CLASS_NAME;
        this.updateUrl();
    }

    protected void updateUrl() {
        StringBuilder buf = new StringBuilder(64);
        buf.append(JDBC_URL_PREFIX);
        buf.append(this.subsubprotocol);
        buf.append(":");
        buf.append(this.database);
        if (this.create) {
            buf.append(";create=true");
        }
        this.url = buf.toString();
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
        this.updateUrl();
    }

    public boolean isCreate() {
        return this.create;
    }

    public void setCreate(boolean create) {
        this.create = create;
        this.updateUrl();
    }
}

